/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

#include "opDocument.h"

OPDocumentIf::OPDocumentIf()
{
  ADD_INTERFACE( "IDL:OpenParts/Document:1.0" );
}

OPDocumentIf::~OPDocumentIf()
{
  cleanUp();
}

void OPDocumentIf::cleanUp()
{
  if ( m_bIsClean )
    return;
  
  KOMComponent::cleanUp();
}

void OPDocumentIf::viewList( OpenParts::Document::ViewList*& _list )
{
  (*_list).length( m_lstViews.count() );

  int i = 0;
  QListIterator<OPViewIf> it( m_lstViews );
  for( ; it.current(); ++it )
  {
    (*_list)[i++] = OpenParts::View::_duplicate( it.current() );
  }
}

void OPDocumentIf::registerView( OPViewIf* _view )
{
  m_lstViews.append( _view );
}

void OPDocumentIf::unregisterView( OPViewIf* _view )
{
  m_lstViews.removeRef( _view );
}

