/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

#include "opFrame.h"

#include <X11/Xlib.h>

OPFrame::OPFrame( QWidget *_parent, const char *_name )
  : QWidget( _parent, _name )
{
  setFocusPolicy(StrongFocus);
}

OPFrame::~OPFrame()
{ 
  if ( CORBA::is_nil( m_rPart ) )
    return;
 
  detach();
}
  
bool OPFrame::attach( OpenParts::Part_ptr _control )
{
  if ( !isVisible() )
       cerr << "Oh oh .... this will lead to trouble ..." << endl;

  if ( !CORBA::is_nil( m_rPart ) )
    detach();
  
  m_rPart = OpenParts::Part::_duplicate( _control );

  if ( CORBA::is_nil( m_rPart ) )
    return false;

  cerr << "Swallowing" << endl;
  
  Window w = (Window)m_rPart->window();
  Window window = w;
  
  KWM::prepareForSwallowing(w);

  XReparentWindow(qt_xdisplay(), w, winId(), 0, 0);
  XMapRaised(qt_xdisplay(), w);
  // XResizeWindow(qt_xdisplay(), window, parentWidget()->width(), parentWidget()->height());
  XResizeWindow(qt_xdisplay(), window, width(), height());

  show();
  /*
  Window src = 
  Window window = src;
  if ( src == 0L )
  {
    cout << "ERROR: Part has no window attached to it" << endl;
    return false;
  }
  Window dest = winId();
  cout << "src=" << (int)src << " dest=" << (int)dest << endl;
  KWM::prepareForSwallowing(src);
  cout << "Swallowed" << endl;
  XReparentWindow(qt_xdisplay(), src, winId(), 0, 0);
  XMapRaised(qt_xdisplay(), src);
  // XAddToSaveSet(qt_xdisplay(), src);
  XMoveResizeWindow(qt_xdisplay(), window, 0, 0, width(), height());
  // show();
  cout << "SHOWN" << endl;
  m_rPart->show( true );
  // cout << "Doing the rest" << endl;
  // m_rPart->setPosition( 0, 0 );
  // m_rPart->setSize( width(), height() );
  */
  return true;
}

void OPFrame::detach()
{
  m_rPart = 0L;
}

void OPFrame::resizeEvent( QResizeEvent * )
{
  if ( CORBA::is_nil( m_rPart ) )
    return;

  cout << "void OPFrame::resizeEvent( QResizeEvent *_ev )" << endl;
  // m_rPart->show( true );
  // m_rPart->setSize( width(), height() );
  Window window = (Window)m_rPart->window();
  XResizeWindow(qt_xdisplay(), window, width(), height());
}

void OPFrame::focusInEvent( QFocusEvent * )
{
  // workarund: put the focus onto the swallowed widget (ettrich)
  // TODO: When we switch to a newer qt than qt-1.33 this hack should
  // be replaced with my new kswallow widget!
  if (isActiveWindow() && isVisible()){ // isActiveWindow is important here!
    // verify wether the window still belongs to us
    unsigned int nwins;
    Window dw1, dw2, *wins;
    XQueryTree(qt_xdisplay(), winId(), 
	       &dw1, &dw2, &wins, &nwins);
    if (nwins)
    {
      Window window = (Window)m_rPart->window();
      XSetInputFocus(qt_xdisplay(), window, RevertToParent, CurrentTime);
    }
  }
}

OpenParts::Part_ptr OPFrame::part()
{
  return OpenParts::Part::_duplicate( m_rPart );
}

#include "opFrame.moc"
