/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

#ifndef __op_frame_h__
#define __op_frame_h__

#include <kom.h>
#include "openparts.h"
#include "opPart.h"

#include <qwidget.h>
#include <kapp.h>
#include <kwm.h>

class OPFrame : public QWidget
{
  Q_OBJECT
public:
  // C++
  OPFrame( QWidget *_parent = 0L, const char *_name = 0L );
  /**
   * The Destructor calls @ref #detach automatically. 
   */
  ~OPFrame();
  
  /**
   * If 'attach' is called twice, then the first control attached
   * becomes detached automatically. The controls reference becomes
   * increased.
   */
  virtual bool attach( OpenParts::Part_ptr _part );
  /**
   * The controls reference becomes decreased.
   */
  virtual void detach();

  virtual OpenParts::Part_ptr part();
  
protected:
  void resizeEvent( QResizeEvent *_ev );
  void focusInEvent( QFocusEvent * );
  
  OPPart_ref m_rPart;
};

#endif
