/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

#ifndef __op_tool_bar_manager_h__
#define __op_tool_bar_manager_h__

#include "openparts.h"
#include <openparts_ui.h>
#include <komBase.h>

#include <map>

class OPMainWindow;
class OPToolBarFactory;

class OPToolBarManager : virtual public KOMBase,
			 virtual public OpenParts::ToolBarManager_skel
{
public:
  OPToolBarManager( OPMainWindow* _main );
  ~OPToolBarManager();

  // IDL
  virtual void registerClient( OpenParts::Id id, KOM::Base_ptr client );
  /**
   * If a part calls this function and holds still the tool bar, then it gets an
   * event to release the tool bar. In addition the toolbar is cleared at once so that
   * the user can no longer access the tool of the unregistered part.
   */
  virtual void unregisterClient( OpenParts::Id id );
  
  // C++
  virtual void create( OpenParts::Id id = 0 );
  virtual void clear();
  
protected:
  OPMainWindow* m_pMainWindow;
  
  OPToolBarFactory* m_pToolBarFactory;

  OpenParts::Id m_activeId;
  
  map<OpenParts::Id,KOM::Base_var> m_mapCallbacks;
};


#endif
