#include "opColorBar.h"
#include "opColorBarIf.h"
#include <qpainter.h>
#include <qdrawutl.h>

ColorField::ColorField (int idx, const QBrush& b, QWidget* parent, 
			const char* name) 
  : QButton (parent, name) {
  id = idx;
  setFixedSize (15, 15);
  resize (15, 15);
  _brush = b;
  highlighted = false;
}

void ColorField::drawButton (QPainter* p) {
  QRect r = rect ();
  QBrush fill (_brush.color ());
  qDrawShadeRect (p, r, colorGroup (), TRUE, 1, 1, &fill);
  if (_brush.style () == NoBrush) {
    p->setPen (QPen (black, 1));
    p->drawLine (1, 1, 13, 13);
    p->drawLine (13, 1, 1, 13);
  }
}

void ColorField::mouseReleaseEvent (QMouseEvent* e) {
  if (e->state () == RightButton) 
    emit fgColorSelected (id);
  else if (e->state () == LeftButton)
    emit bgColorSelected (id);
}

void ColorField::highlight (bool flag) {
  if (highlighted != flag) {
    highlighted = flag;
    repaint ();
  }
}

OPColorBar::OPColorBar (QWidget *_parent, const char *_name, int _item_size)
  : KToolBar (_parent, _name, _item_size) {
  m_pInterface = 0L;
  cerr << "OPColorBar::OPColorBar()" << endl;
}

OPColorBar::~OPColorBar () {
  cerr << "OPColorBar::~OPColorBar()" << endl;
  
  if (m_pInterface) {
    cerr << " cleanUp OPColorBar::~OPColorBar()" << endl;
    m_pInterface->cleanUp();
    CORBA::release (m_pInterface);
  }

  cerr << " ende OPColorBar::~OPColorBar()" << endl;
}

OPColorBarIf* OPColorBar::interface () {
  if (m_pInterface == 0L)
    m_pInterface = new OPColorBarIf (this);
 
  return m_pInterface;
}

void OPColorBar::insertColorButton (int idx, short red, 
				    short green, short blue, bool fill) {
  QBrush brush;
  brush = QBrush (QColor (red, green, blue), fill ? SolidPattern : NoBrush);
  ColorField* cfield = new ColorField (idx, brush, this);
  connect (cfield, SIGNAL(fgColorSelected (int)), this,
	   SLOT(slotFgColorChanged (int)));
  connect (cfield, SIGNAL(bgColorSelected (int)), this,
	   SLOT(slotBgColorChanged (int)));
  insertWidget (idx, cfield->width (), cfield);
  fields[idx] = cfield;
}

bool OPColorBar::getColor (int idx, short& red, short& green, short& blue,
			   unsigned char& fill) {
  map<int, ColorField*>::iterator i = fields.find (idx); 
  if (i != fields.end ()) {
    const QBrush& brush = i->second->brush ();
    red = brush.color ().red ();
    green = brush.color ().green ();
    blue = brush.color ().blue ();
    fill = (brush.style () != NoBrush);
    return true;
  }
  else
    return false;
}

void OPColorBar::slotFgColorChanged (int id) {
  for (map<int, ColorField*>::iterator i = fields.begin (); 
       i != fields.end (); i++)
    i->second->highlight (i->first == id);
  emit fgColorSelected (id);
}

void OPColorBar::slotBgColorChanged (int id) {
  emit bgColorSelected (id);
}

#include "opColorBar.moc"
