/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

/*
Sun Dec 20 20:30:17 1998 Simon Hausmann <tronical@gmx.net>
    * added support for signals "highlighted" and "aboutToShow"
*/

#ifndef __OP_menu_h__
#define __OP_menu_h__

#include <qpopupmenu.h>
#include <qintdict.h>

#include <kmenubar.h>

class OPMenuIf;
class OPMenuBarIf;
class OPMenuBar;

class OPMenu : public QPopupMenu
{
  Q_OBJECT
public:
  OPMenu( OPMenuBar* _bar );
  ~OPMenu();

  virtual OPMenuIf* interface();
  virtual OPMenuBar* menuBar() { return m_pMenuBar; }

  virtual void cleanUp();
  
protected slots:
  void slotActivated( int _id );
  void slotHighlighted( int _id );
  void slotAboutToShow();
  
protected:
  OPMenuIf* m_pInterface;
  OPMenuBar* m_pMenuBar;
};

class OPMenuBar : public KMenuBar
{
  Q_OBJECT
public:
  OPMenuBar( QWidget *_parent );
  ~OPMenuBar();
  
  virtual int insertItem(const char *text, QPopupMenu *popup, int id=-1, int index=-1 );
  virtual OPMenu* menuAt( int index );
  virtual OPMenu* menu( int id );

  virtual OPMenu* helpMenu();
  virtual void setHelpMenu( OPMenu* _menu );
  virtual OPMenu* fileMenu();
  virtual void setFileMenu( OPMenu* _menu );

  virtual void reset();
  
  virtual OPMenuBarIf* interface();

protected slots:
  virtual void slotActivated2( int id );
  virtual void slotHighlighted2( int id );

protected:
  OPMenuBarIf* m_pInterface;
  OPMenu* m_pHelpMenu;
  OPMenu* m_pFileMenu;
  
  QIntDict<OPMenu> m_mapMenus;
};

#endif

