/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

#include "opQCProxy.h"

/******************************************************************
 *
 * Qt2CORBAProxy
 *
 ******************************************************************/

Qt2CORBAProxy::Qt2CORBAProxy( CORBA::Object_ptr _receiver, const char *_member )
{
  m_vReceiver = CORBA::Object::_duplicate( _receiver );
  m_strMember = _member;
}

void Qt2CORBAProxy::callback()
{
  cerr << "Calling method '" << m_strMember << "'" << endl;
  
  CORBA::Request_var _req = m_vReceiver->_request( m_strMember.c_str() );
  _req->result()->value()->type( CORBA::_tc_void );
  _req->invoke();

  cerr << "Call done" << endl;

  /*
  if( _req->env()->exception() )
  {
    CORBA::Exception *_ex = _req->env()->exception();
    CORBA::UnknownUserException *_uuex = CORBA::UnknownUserException::_narrow( _ex );
    if( _uuex )
    {
      mico_throw( CORBA::UNKNOWN() );
    }
    else
    {
      mico_throw( *_ex );
    }
    } */
}

void Qt2CORBAProxy::callback( int _val )
{
  cerr << "Calling method '" << m_strMember << "'" << endl;
  
  CORBA::Request_var _req = m_vReceiver->_request( m_strMember.c_str() );
  _req->add_in_arg( "value" ) <<= (CORBA::Long)_val;
  _req->result()->value()->type( CORBA::_tc_void );
  _req->invoke();

  cerr << "Call done" << endl;
  
  if( _req->env()->exception() )
  {
    CORBA::Exception *_ex = _req->env()->exception();
    CORBA::UnknownUserException *_uuex = CORBA::UnknownUserException::_narrow( _ex );
    if( _uuex )
    {
      mico_throw( CORBA::UNKNOWN() );
    }
    else
    {
      mico_throw( *_ex );
    }
  }
}

void Qt2CORBAProxy::callback( const char* _val )
{
  cerr << "Calling method '" << m_strMember << "'" << endl;
  
  CORBA::Request_var _req = m_vReceiver->_request( m_strMember.c_str() );
  _req->add_in_arg( "value" ) <<= CORBA::Any::from_string( (char *) _val, 0 );
  _req->result()->value()->type( CORBA::_tc_void );
  _req->invoke();

  cerr << "Call done" << endl;
  
  if( _req->env()->exception() )
  {
    CORBA::Exception *_ex = _req->env()->exception();
    CORBA::UnknownUserException *_uuex = CORBA::UnknownUserException::_narrow( _ex );
    if( _uuex )
    {
      mico_throw( CORBA::UNKNOWN() );
    }
    else
    {
      mico_throw( *_ex );
    }
  }
}

#include "opQCProxy.moc"
