/*
  Author: Simon Hausmann <tronical@gmx.net>
*/

#include "opStatusBar.h"
#include "opStatusBarIf.h"

OPStatusBar::OPStatusBar( QWidget *_parent, const char *_name )
  : KStatusBar( _parent, _name )
{
  m_pInterface = 0L;
  
  connect( this, SIGNAL( pressed( int ) ),
           this, SLOT( slotPressed( int ) ) );
  connect( this, SIGNAL( released( int ) ),
           this, SLOT( slotReleased( int ) ) );	   
}

OPStatusBar::~OPStatusBar()
{
  cerr << "OPStatusBar::~OPStatusBar()" << endl;
  
  if ( m_pInterface )
  {
    cerr << " cleanUp OPStatusBar::~OPStatusBar()" << endl;
    m_pInterface->cleanUp();
    CORBA::release( m_pInterface );
  }

  cerr << " ende OPStatusBar::~OPStatusBar()" << endl;
}

OPStatusBarIf* OPStatusBar::interface()
{
  if ( m_pInterface == 0L )
    m_pInterface = new OPStatusBarIf( this );
 
  return m_pInterface;
}

void OPStatusBar::slotPressed( int ID )
{
  if (m_pInterface)
     m_pInterface->pressed( ID );
}

void OPStatusBar::slotReleased( int ID )
{
  if (m_pInterface)
     m_pInterface->released( ID );
}
     
#include "opStatusBar.moc"
