/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

#include "opToolBar.h"
#include "opToolBarIf.h"

OPToolBar::OPToolBar( QWidget *_parent, const char *_name, int _item_size )
  : KToolBar( _parent, _name, _item_size )
{
  m_pInterface = 0L;
  
  connect( this, SIGNAL( clicked( int ) ),
           this, SLOT( slotClicked( int ) ) );
  connect( this, SIGNAL( doubleClicked( int ) ),
           this, SLOT( slotDoubleClicked( int ) ) );
  connect( this, SIGNAL( pressed( int ) ),
           this, SLOT( slotPressed( int ) ) );
  connect( this, SIGNAL( released( int ) ),
           this, SLOT( slotReleased( int ) ) );
  connect( this, SIGNAL( toggled( int ) ),
           this, SLOT( slotToggled( int ) ) );
  connect( this, SIGNAL( highlighted( int, bool ) ),
           this, SLOT( slotHighlighted( int, bool ) ) );	   	   	   	   	   
}

OPToolBar::~OPToolBar()
{
  cerr << "OPToolBar::~OPToolBar()" << endl;
  
  if ( m_pInterface )
  {
    cerr << " cleanUp OPToolBar::~OPToolBar()" << endl;
    m_pInterface->cleanUp();
    CORBA::release( m_pInterface );
  }

  cerr << " ende OPToolBar::~OPToolBar()" << endl;
}

OPToolBarIf* OPToolBar::interface()
{
  if ( m_pInterface == 0L )
    m_pInterface = new OPToolBarIf( this );
 
  return m_pInterface;
}

void OPToolBar::slotClicked( int id )
{
  if ( m_pInterface )
    m_pInterface->clicked( id );
}

void OPToolBar::slotDoubleClicked( int id )
{
  if ( m_pInterface )
    m_pInterface->doubleClicked( id );
}

void OPToolBar::slotPressed( int id )
{
  if ( m_pInterface )
    m_pInterface->pressed( id );
}

void OPToolBar::slotReleased( int id )
{
  if ( m_pInterface )
    m_pInterface->released( id );
}

void OPToolBar::slotToggled( int id )
{
  if ( m_pInterface )
    m_pInterface->toggled( id );
}

void OPToolBar::slotHighlighted( int id, bool isHighlighted )
{
  if ( !isHighlighted ) id = -1;
  if ( m_pInterface )
    m_pInterface->highlighted( id );
}    

#include "opToolBar.moc"
