/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

#include "opToolBarIf.h"
#include "opColorBarIf.h"
#include "opUIUtils.h"

#include <string.h>
#include <assert.h>

#include <qstrlist.h>
#include <ktmainwindow.h>

OPToolBarIf::OPToolBarIf( OPToolBar* _toolbar )
{
  m_pToolBar = _toolbar;
  
  SIGNAL_IMPL( "clicked" );
  SIGNAL_IMPL( "doubleClicked" );
  SIGNAL_IMPL( "pressed" );
  SIGNAL_IMPL( "released" );
  SIGNAL_IMPL( "toggled" );
  SIGNAL_IMPL( "highlighted");
}

OPToolBarIf::~OPToolBarIf()
{
  cerr << "OPToolBarIf::~OPToolBarIf() " << (int)this << endl;
  cleanUp();
}

void OPToolBarIf::cleanUp()
{
  cerr << "void OPToolBarIf::cleanUp() " << (int)this << endl;
  
  multimap<int,Qt2CORBAProxy*>::iterator it = m_mapProxies.begin();
  for( ; it != m_mapProxies.end(); ++it )
    delete it->second;
  m_mapProxies.clear();
}

CORBA::Long OPToolBarIf::insertButton( const OpenPartsUI::Pixmap& pixmap, CORBA::Long id, CORBA::Boolean enabled,
				       const char* toolTipText, CORBA::Long index )
{
  QPixmap qpix( OPUIUtils::convertPixmap( pixmap ) );
  
  int res = m_pToolBar->insertButton( qpix, (int)id, (bool)enabled, toolTipText, index );

  return (CORBA::Long)res;
}

CORBA::Long OPToolBarIf::insertButton2( const OpenPartsUI::Pixmap& pixmap, CORBA::Long id, const char* signalname,
					CORBA::Object_ptr receiver, const char* slotname, CORBA::Boolean enabled,
					const char* tooltiptext, CORBA::Long index )
{
  Qt2CORBAProxy* proxy = new Qt2CORBAProxy( receiver, slotname );
  QPixmap qpix( OPUIUtils::convertPixmap( pixmap ) );
  
  // TODO: Depending on signalname, we have to connect to the correct slot of the proxy
  int res = m_pToolBar->insertButton( qpix, (int)id, signalname, proxy, SLOT( callback() ), enabled, tooltiptext, (int)index );
  m_mapProxies.insert(pair<int,Qt2CORBAProxy*>( res, proxy ) );

  return (CORBA::Long)res;
}

CORBA::Long OPToolBarIf::insertButton3( const OpenPartsUI::Pixmap& pixmap, CORBA::Long id, OpenPartsUI::Menu_ptr& popup,
					CORBA::Boolean enabled, const char* text, CORBA::Long index )
{
  // TODO
  assert( 0 );
}

CORBA::Long OPToolBarIf::insertLined( const char* text, CORBA::Long id, const char* signalname, CORBA::Object_ptr receiver,
				      const char* slotname, CORBA::Boolean enabled, const char* toolTipText,
				      CORBA::Long size, CORBA::Long index )
{
  int res;
  if ( strlen( slotname ) > 0 && strlen( signalname ) > 0 && !CORBA::is_nil( receiver ) )
  {
    Qt2CORBAProxy* proxy = new Qt2CORBAProxy( receiver, slotname );
    // TODO: Depending on signalname, we have to connect to the correct slot of the proxy
    res = m_pToolBar->insertLined( text, (int)id, signalname, proxy, SLOT( callback() ), (bool)enabled, toolTipText,
				       (int)size, (int)index );
    m_mapProxies.insert(pair<int,Qt2CORBAProxy*>( res, proxy ) );
  }
  else
    res = m_pToolBar->insertLined( text, (int)id, 0L, 0L, 0L, (bool)enabled, toolTipText,
				       (int)size, (int)index );

  return (CORBA::Long)res;
}

CORBA::Long OPToolBarIf::insertCombo( const OpenPartsUI::StrList& list, CORBA::Long id, CORBA::Boolean writable, const char* signalname,
				      CORBA::Object_ptr receiver, const char* slotname, CORBA::Boolean enabled,
				      const char* tooltiptext, CORBA::Long size, CORBA::Long index, OpenPartsUI::ComboBoxPolicy policy )
{
  QComboBox::Policy qpolicy;
  switch( policy )
    {
    case OpenPartsUI::NoInsertion:
      qpolicy = QComboBox::NoInsertion;
      break;
    case OpenPartsUI::AtTop:
      qpolicy = QComboBox::AtTop;
      break;
    case OpenPartsUI::AtBottom:
      qpolicy = QComboBox::AtBottom;
      break;
    case OpenPartsUI::AfterCurrent:
      qpolicy = QComboBox::AfterCurrent;
      break;
    case OpenPartsUI::BeforeCurrent:
      qpolicy = QComboBox::BeforeCurrent;
      break;
    case OpenPartsUI::AtCurrent:
      qpolicy = QComboBox::AtCurrent;
      break;
    }
  
  QStrList qlist;
  unsigned int l = list.length();
  for( unsigned int i = 0; i < l; i++ )
    qlist.append( list[i] );

  int res;
  if ( strlen( slotname ) > 0 && strlen( signalname ) > 0 && !CORBA::is_nil( receiver ) )
  {
    Qt2CORBAProxy* proxy = new Qt2CORBAProxy( receiver, slotname );
    // TODO: Depending on signalname, we have to connect to the correct slot of the proxy
    res = m_pToolBar->insertCombo( &qlist, (int)id, (bool)writable, signalname, proxy, SLOT( callback( const char* ) ), (bool)enabled,
				       tooltiptext, (int)size, (int)index, qpolicy );
    m_mapProxies.insert(pair<int,Qt2CORBAProxy*>( res, proxy ) );
  }
  else
    res = m_pToolBar->insertCombo( &qlist, (int)id, (bool)writable, 0L, 0L, 0L, (bool)enabled,
				       tooltiptext, (int)size, (int)index, qpolicy );

  return (CORBA::Long)res;
}

CORBA::Long OPToolBarIf::insertCombo2( const char* text, CORBA::Long id, CORBA::Boolean writable, const char* signalname,
				       CORBA::Object_ptr receiver, const char* slotname, CORBA::Boolean enabled,
				       const char* tooltiptext, CORBA::Long size, CORBA::Long index, OpenPartsUI::ComboBoxPolicy policy )
{
  QComboBox::Policy qpolicy;
  switch( policy )
    {
    case OpenPartsUI::NoInsertion:
      qpolicy = QComboBox::NoInsertion;
      break;
    case OpenPartsUI::AtTop:
      qpolicy = QComboBox::AtTop;
      break;
    case OpenPartsUI::AtBottom:
      qpolicy = QComboBox::AtBottom;
      break;
    case OpenPartsUI::AfterCurrent:
      qpolicy = QComboBox::AfterCurrent;
      break;
    case OpenPartsUI::BeforeCurrent:
      qpolicy = QComboBox::BeforeCurrent;
      break;
    case OpenPartsUI::AtCurrent:
      qpolicy = QComboBox::AtCurrent;
      break;
    }

  int res;
  if ( strlen( slotname ) > 0 && strlen( signalname ) > 0 && !CORBA::is_nil( receiver ) )
  {
    Qt2CORBAProxy* proxy = new Qt2CORBAProxy( receiver, slotname );
    // TODO: Depending on signalname, we have to connect to the correct slot of the proxy
    res = m_pToolBar->insertCombo( text, (int)id, (bool)writable, signalname, proxy, SLOT( callback() ), (bool)enabled,
				       tooltiptext, (int)size, (int)index, qpolicy );
    m_mapProxies.insert(pair<int,Qt2CORBAProxy*>( res, proxy ) );
  }
  else
    res = m_pToolBar->insertCombo( text, (int)id, (bool)writable, 0L, 0L, 0L, (bool)enabled,
				       tooltiptext, (int)size, (int)index, qpolicy );

  return (CORBA::Long)res;
}

CORBA::Long OPToolBarIf::insertSeparator( CORBA::Long index )
{
  int res = m_pToolBar->insertSeparator( (int)index );
  return (CORBA::Long)res;
}

CORBA::Long OPToolBarIf::insertTextLabel( const char *text, CORBA::Long id, CORBA::Long index )
{
  QLabel *l = new QLabel( text, m_pToolBar );
  l->adjustSize();
  
  return (CORBA::Long) m_pToolBar->insertWidget( (int)id, l->width(), l, (int)index );
}

void OPToolBarIf::addConnection( CORBA::Long id, const char* signalname, CORBA::Object_ptr receiver, const char* slotname )
{
  if ( strlen( slotname ) > 0 && strlen( signalname ) > 0 && !CORBA::is_nil( receiver ) )
  {
    Qt2CORBAProxy* proxy = new Qt2CORBAProxy( receiver, slotname );
    // TODO: Depending on signalname, we have to connect to the correct slot of the proxy
    m_pToolBar->addConnection( (int)id, signalname, proxy, SLOT( callback() ) );
    m_mapProxies.insert(pair<int,Qt2CORBAProxy*>( id, proxy ) );
  }
}

void OPToolBarIf::setItemEnabled( CORBA::Long id, CORBA::Boolean enabled )
{
  m_pToolBar->setItemEnabled( (int)id, (bool)enabled );
}

void OPToolBarIf::setButtonPixmap( CORBA::Long id, const OpenPartsUI::Pixmap& pixmap )
{
  QPixmap qpix( OPUIUtils::convertPixmap( pixmap ) );
  m_pToolBar->setButtonPixmap( (int)id, qpix );
}

void OPToolBarIf::setDelayedPopup( CORBA::Long id, OpenPartsUI::Menu_ptr& popup )
{
  // TODO
  assert( 0 );
}

void OPToolBarIf::setToggle( CORBA::Long id, CORBA::Boolean flag )
{
  m_pToolBar->setToggle( (int)id, (bool)flag );
}

void OPToolBarIf::toggleButton( CORBA::Long id )
{
  m_pToolBar->toggleButton( (int)id );
}

void OPToolBarIf::setButton( CORBA::Long id, CORBA::Boolean flag )
{
  m_pToolBar->setButton( (int)id, (bool)flag );
}

CORBA::Boolean OPToolBarIf::isButtonOn( CORBA::Long id )
{
  return (CORBA::Boolean)m_pToolBar->isButtonOn( (int)id );
}

void OPToolBarIf::setLinedText( CORBA::Long id, const char* text )
{
  m_pToolBar->setLinedText( (int)id, text );
}

char* OPToolBarIf::linedText( CORBA::Long id )
{
  return CORBA::string_dup( m_pToolBar->getLinedText( (int)id ) );
}

void OPToolBarIf::insertComboItem( CORBA::Long id, const char* text, CORBA::Long index )
{
  m_pToolBar->insertComboItem( (int)id, text, (int)index );
}

void OPToolBarIf::insertComboList( CORBA::Long id, const OpenPartsUI::StrList& list, CORBA::Long index )
{
  QStrList qlist;
  unsigned int l = list.length();
  for( unsigned int i = 0; i < l; i++ )
    qlist.append( list[i] );

  m_pToolBar->insertComboList( (int)id, &qlist, (int)index );
}

void OPToolBarIf::removeComboItem( CORBA::Long id, CORBA::Long index )
{
  m_pToolBar->removeComboItem( (int)id, (int)index );
}

void OPToolBarIf::setCurrentComboItem( CORBA::Long id, CORBA::Long index )
{
  m_pToolBar->setCurrentComboItem( (int)id, (int)index );
}

void OPToolBarIf::changeComboItem( CORBA::Long id, const char* text, CORBA::Long index )
{
  m_pToolBar->changeComboItem( (int)id, text, (int)index );
}

void OPToolBarIf::clearCombo( CORBA::Long id )
{
  m_pToolBar->clearCombo( (int)id );
}

char* OPToolBarIf::comboItem( CORBA::Long id, CORBA::Long index )
{
  return CORBA::string_dup( m_pToolBar->getComboItem( (int)id, (int)index ) );
}

void OPToolBarIf::alignItemRight( CORBA::Long id, CORBA::Boolean right )
{
  m_pToolBar->alignItemRight( (int)id, (bool)right );
}

void OPToolBarIf::setItemAutoSized( CORBA::Long id, CORBA::Boolean yes )
{
  m_pToolBar->setItemAutoSized( (int)id, (bool)yes );
}

void OPToolBarIf::removeItem( CORBA::Long id )
{
  m_pToolBar->removeItem( (int)id );
}

void OPToolBarIf::hideItem( CORBA::Long id )
{
  m_pToolBar->hideItem( (int)id );
}

void OPToolBarIf::showItem( CORBA::Long id )
{
  m_pToolBar->showItem( (int)id );
}

void OPToolBarIf::setFullWidth( CORBA::Boolean flag )
{
  m_pToolBar->setFullWidth( (bool)flag );
}

void OPToolBarIf::enableMoving( CORBA::Boolean flag )
{
  m_pToolBar->enableMoving( (bool)flag );
}

void OPToolBarIf::setBarPos( OpenPartsUI::BarPosition bpos )
{
  KToolBar::BarPosition pos;
  switch( bpos )
    {
    case OpenPartsUI::Top:
      pos = KToolBar::Top;
      break;
    case OpenPartsUI::Left:
      pos = KToolBar::Left;
      break;
    case OpenPartsUI::Bottom:
      pos = KToolBar::Bottom;
      break;
    case OpenPartsUI::Right:
      pos = KToolBar::Right;
      break;
    case OpenPartsUI::Floating:
      pos = KToolBar::Floating;
      break;
    }
  
  m_pToolBar->setBarPos( pos );
}

OpenPartsUI::BarPosition OPToolBarIf::barPos()
{
  OpenPartsUI::BarPosition pos;
  switch( m_pToolBar->barPos() )
    {
    case KToolBar::Top:
      pos = OpenPartsUI::Top;
      break;
    case KToolBar::Left:
      pos = OpenPartsUI::Left;
      break;
    case KToolBar::Bottom:
      pos = OpenPartsUI::Bottom;
      break;
    case KToolBar::Right:
      pos = OpenPartsUI::Right;
      break;
    case KToolBar::Floating:
      pos = OpenPartsUI::Floating;
      break;
    }

  return pos;
}

CORBA::Boolean OPToolBarIf::enable( OpenPartsUI::BarStatus stat )
{
  KToolBar::BarStatus s;
  switch( stat )
    {
    case OpenPartsUI::Toggle:
      s = KToolBar::Toggle;
      break;
    case OpenPartsUI::Show:
      s = KToolBar::Show;
      // Workaround for KToolBar bug
      if (m_pToolBar->barPos () == KToolBar::Floating)
	m_pToolBar->move (QCursor::pos ());
      break;
    case OpenPartsUI::Hide:
      s = KToolBar::Hide;
      // Workaround for KToolBar bug
      if (m_pToolBar->barPos () == KToolBar::Floating)
	m_pToolBar->move (10000, 10000);
      break;
    }
  
  return (CORBA::Boolean)m_pToolBar->enable( s );
}

void OPToolBarIf::setMaxHeight( CORBA::Long h )
{
  m_pToolBar->setMaxHeight( (int)h );
}

void OPToolBarIf::setMaxWidth( CORBA::Long dw )
{
  m_pToolBar->setMaxWidth( (int)dw );
}

void OPToolBarIf::setTitle( const char* title )
{
  m_pToolBar->setTitle( title );
}

void OPToolBarIf::enableFloating( CORBA::Boolean flag )
{
  m_pToolBar->enableFloating( flag );
}

void OPToolBarIf::setIconText( CORBA::Long id )
{
  m_pToolBar->setIconText( (int)id );
}

void OPToolBarIf::changeLabelText( CORBA::Long id, const char *text )
{
  QWidget *w = m_pToolBar->getWidget(id);

  if (w && w->inherits("QLabel"))
     {
       QLabel *l = (QLabel *)w;
       l->setText( text );
       l->adjustSize();
     }  
}

void OPToolBarIf::clicked( CORBA::Long id )
{
  SIGNAL_CALL1( "clicked", id );
}

void OPToolBarIf::doubleClicked( CORBA::Long id )
{
  SIGNAL_CALL1( "doubleClicked", id );
}

void OPToolBarIf::pressed( CORBA::Long id )
{
  SIGNAL_CALL1( "pressed", id );
}

void OPToolBarIf::released( CORBA::Long id )
{
  SIGNAL_CALL1( "released", id );
}

void OPToolBarIf::toggled( CORBA::Long id )
{
  SIGNAL_CALL1( "toggled", id );
}

void OPToolBarIf::highlighted( CORBA::Long id )
{
  SIGNAL_CALL1( "highlighted", id );
}

/************************************************************
 *
 * OPToolBarFactory
 *
 ************************************************************/

OPToolBarFactory::OPToolBarFactory( KTMainWindow *_main ) : OpenPartsUI::ToolBarFactory_skel()
{
  m_pMainWindow = _main;

  m_lstPersistentBars.setAutoDelete( true );
  m_lstTransientBars.setAutoDelete( true );
}

OPToolBarFactory::~OPToolBarFactory()
{
}

OpenPartsUI::ToolBar_ptr OPToolBarFactory::create( OpenPartsUI::ToolBarFactory::Modus _modus )
{
  if ( _modus == OpenPartsUI::ToolBarFactory::Persistent )
  {    
    OPToolBar* bar = new OPToolBar( m_pMainWindow );
    m_pMainWindow->addToolBar( bar );
    m_lstPersistentBars.append( bar );
    return OpenPartsUI::ToolBar::_duplicate( bar->interface() );
  }
  else if ( _modus == OpenPartsUI::ToolBarFactory::Transient )
  {    
    OPToolBar* bar = new OPToolBar( m_pMainWindow );
    m_pMainWindow->addToolBar( bar );
    m_lstTransientBars.append( bar );
    return OpenPartsUI::ToolBar::_duplicate( bar->interface() );
  }
  else
    assert( 0 );
}

OpenPartsUI::ColorBar_ptr OPToolBarFactory::createColorBar (OpenPartsUI::ToolBarFactory::Modus _modus) {
  if ( _modus == OpenPartsUI::ToolBarFactory::Persistent )
  {    
    OPColorBar* bar = new OPColorBar( m_pMainWindow );
    m_pMainWindow->addToolBar( bar );
    m_lstPersistentBars.append( bar );
    return OpenPartsUI::ColorBar::_duplicate( bar->interface() );
  }
  else if ( _modus == OpenPartsUI::ToolBarFactory::Transient )
  {    
    OPColorBar* bar = new OPColorBar( m_pMainWindow );
    m_pMainWindow->addToolBar( bar );
    m_lstTransientBars.append( bar );
    return OpenPartsUI::ColorBar::_duplicate( bar->interface() );
  }
  else
    assert( 0 );
}
  
void OPToolBarFactory::removeTransientBars()
{
  m_lstTransientBars.clear();
}
