from libpymico import *

TRUE = 1
FALSE = 0

COMPLETED_YES = 1
COMPLETED_NO = 2
COMPLETED_MAYBE = 3

ARG_IN = 1
ARG_OUT = 2
ARG_INOUT = 4

ATTR_NORMAL = 1
ATTR_READONLY = 2

_tc_null = typecode( 1, "" )
_tc_void = typecode( 2, "" )
_tc_short = typecode( 3, "" )
_tc_long = typecode( 4, "" )
_tc_longlong = typecode( 5, "" )
_tc_ushort = typecode( 6, "" )
_tc_ulong = typecode( 7, "" )
_tc_ulonglong = typecode( 8, "" )
_tc_float = typecode( 9, "" )
_tc_double = typecode( 10, "" )
_tc_longdouble = typecode( 11, "" )
_tc_boolean = typecode( 12, "" )
_tc_char = typecode( 13, "" )
_tc_wchar = typecode( 14, "" )
_tc_octet = typecode( 15, "" )
_tc_any = typecode( 16, "" )
_tc_typecode = typecode( 17, "" )
_tc_Principal = typecode( 18, "" )
_tc_Context = typecode( 19, "" )
_tc_Object = typecode( 20, "" )
_tc_string = typecode( 21, "" )
_tc_wstring = typecode( 22, "" )

class Object:
	def __init__( self, obj="", ior="", repoid="" ):
		if "_init_CORBA.Object_" in self.__dict__.keys():
			return
		self.__dict__["_init_CORBA.Object_"] = 1
		self.__dict__["_attribs_"] = { }
		if obj == "":
			self.__dict__["_ior_"] = ior
			valid = 0
			if ior == "":
				valid = 0
			else:
				if repoid == "":
					valid = 1
				else:
					valid = narrow( ior, repoid )
			if valid == 1:
				self.__dict__["_id_"] = object( ior )
			else:
				self.__dict__["_id_"] = 0
		else:
			self.__dict__["_ior_"] = obj._ior()
			if narrow( self.__dict__["_ior_"], repoid ) == 1:
				self.__dict__["_id_"] = object( self.__dict__["_ior_"] )
			else:
				self.__dict__["_id_"] = 0
	def __del__( self ):
		if self.__dict__["_id_"] != 0:
			if not ( "_del_CORBA.Object_" in self.__dict__.keys() ):
				release_object( self.__dict__["_id_"] )
	def __getattr__( self, name ):
		if not name in self.__dict__["_attribs_"].keys():
			try:
				x = self.__dict__[name]
			except KeyError, v:
				raise AttributeError, name
			return x
		_entry_ = self.__dict__["_attribs_"][name]
		_call_ = "_get_" + name
		_r_ = request( self.__dict__["_ior_"], _call_, _entry_[0] )
		_result_ = invoke( _r_ )
		release_request( _r_ )
		return _result_
	def __setattr__( self, name, value ):
		if name == "_ior_" or name == "_id_":
			self.__dict__[name] = value
			return
		if not name in self.__dict__["_attribs_"].keys():
			raise "InvalidAttribute", name
		_entry_ = self.__dict__["_attribs_"][name]
		if _entry_[1] == ATTR_READONLY:
			raise "Attribute is readonly", name
		_call_ = "_set_" + name
		_r_ = request( self.__dict__["_ior_"], _call_, _tc_void )
		add_param( _r_, "value", value, _entry_[0], 0 )
		invoke( _r_ )
		release_request( _r_ )
	def _ior( self ):
		return self.__dict__["_ior_"]
	def _repoid( self ):
		return object_repoid( self.__dict__["_ior_"] )
	def _is_nil( self ):
		if self.__dict__["_id_"] == 0:
			return 1
		return 0
	def _is_a( self, repoid ):
		return narrow( self.__dict__["_ior_"], repoid )

def newObject( _module="", _class="" ):
	if _module == "" and _class == "":
		return Object()
	if _module == "CORBA" and _class == "Object":
		return Object()
	str = "import " + _module
	exec str
	str = _module + "." + _class + "()"
	return eval( str )

class Server:
	def __init__( self, repoid ):
		self._server_ = server( repoid )
	def _ior( self ):
		return server_ior( self._server_ )

class Struct:
	def __init__( self ):
		return
	def __repr__( self ):
		keys = self.__dict__.keys()
		out = " { "
		for k in keys:
			v = self.__dict__[ k ]
			out = out + k + "=" + str(v) + " "
		out = out + "} "
		return out

def newStruct():
	return Struct()

class Exception:
	def __init__( self ):
		return
	def __repr__( self ):
		keys = self.__dict__.keys()
		out = " { "
		for k in keys:
			v = self.__dict__[ k ]
			out = out + k + "=" + str(v) + " "
		out = out + "} "
		return out

class SystemException( Exception ):
	def __init__( self ):
		Exception.__init__( self )
		return

class UserException( Exception ):
	def __init__( self ):
		Exception.__init__( self )
		return

def newException( _module, _exc, _params ):
	str = "import " + _module
	exec str
	return ( eval( _module + "." + _exc ), apply( eval( _module + "." + _exc ), _params ) )

class Union:
	def __init__( self, d=None, v=None ):
		self.d = d
		self.v = v
	def __repr__( self ):
		keys = self.__dict__.keys()
		out = " { "
		for k in keys:
			v = self.__dict__[ k ]
			out = out + k + "=" + str(v) + " "
		out = out + "} "
		return out

def newUnion():
	return Union()

class Any:
	def __init__( self, typecode=0, value=0 ):
		if typecode != 0:
			self._any_id_ = any( typecode, value )
		else:
			self._any_id = 0
	def __del__( self ):
		if self._any_id_ != 0:
			release_any( self._any_id_ )
	def typecode( self ):
		if self._any_id_ == 0:
			return None
		return any_typecode( self._any_id )
	def value( self ):
		if self._any_id_ == 0:
			return None
		return any_value( self._any_id_ )
	def __repr__( self ):
		if self._any_id_ == 0:
			return "< >"
		out = "< " + str( self.value() ) + " >"
		return out

def newAny():
	return Any()

class ORB:
	def bind( self, repoid, tag="", address="" ):
		return bind( repoid, tag, address )

_orb = ORB()
