/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
 
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/     

#ifndef __main_h__
#define __main_h__

#include "composing.h"

#include <iostream>

#include <komComponent.h>
#include <komAggregate.h>
#include <komPlugin.h>

class Core : virtual public KOMComponent,
	     virtual public MyComponent::Core_skel
{
public:
  Core();
  virtual ~Core();
  
  virtual void sayHello();
  
  // C++
  virtual void cleanUp();
};

class Extension1 : virtual public MyComponent::Extension1_skel
{
public:
  Extension1( KOMComponent* _core );
  virtual ~Extension1();
  
  virtual void sayHello();
};

class Extension2Factory : virtual public KOMAggregateFactory
{
public:
  virtual KOM::Aggregate_ptr create( KOM::Component_ptr core );
};

class Extension2 : virtual public KOMAggregate,
		   virtual public MyExtension::Extension2_skel
{
public:
  Extension2( KOM::Component_ptr core );
  virtual ~Extension2();
  
  virtual void sayHello();
};

class WrapperFactory : virtual public KOMAggregateFactory
{
public:
  virtual KOM::Aggregate_ptr create( KOM::Component_ptr core );
};

class Wrapper : virtual public KOMAggregate,
		virtual public MyExtension::Wrapper_skel
{
public:
  Wrapper( KOM::Component_ptr core );
  virtual ~Wrapper();

  virtual void talk( const char *_message );  
};

class Extension4Factory : virtual public KOMAggregateFactory
{
public:
  virtual KOM::Aggregate_ptr create( KOM::Component_ptr core );
};

class Extension4 : virtual public KOMAggregate,
		   virtual public MyExtension::Extension4_skel
{
public:
  Extension4( KOM::Component_ptr _core );
  virtual ~Extension4();
  
  virtual void sayNiceHello();

  // C++
  virtual void cleanUp();

protected:
  MyInterfaces::Talk_var m_vWrapper;
};

class Plugin1Factory : virtual public KOMPluginFactory
{
public:
  virtual KOM::Plugin_ptr create( KOM::Component_ptr core );
};

class Plugin1 : virtual public KOMPlugin,
		virtual public MyExtension::Plugin1_skel
{
public:
  Plugin1( KOM::Component_ptr core );
  virtual ~Plugin1();
  
  virtual void sayHello();
};

class Plugin2Factory : virtual public KOMPluginFactory
{
public:
  virtual KOM::Plugin_ptr create( KOM::Component_ptr core );
};

class Plugin2 : virtual public KOMPlugin,
		virtual public MyExtension::Plugin2_skel
{
public:
  Plugin2( KOM::Component_ptr _core );
  virtual ~Plugin2();
  
  virtual void sayHello();
 
  // C++
  virtual void cleanUp();

protected:
  MyExtension::PluginWrapper_var m_vWrapper;
};

class PluginWrapperFactory : virtual public KOMPluginFactory
{
public:
  virtual KOM::Plugin_ptr create( KOM::Component_ptr core );
};

class PluginWrapper : virtual public KOMPlugin,
		      virtual public MyExtension::PluginWrapper_skel
{
public:
  PluginWrapper( KOM::Component_ptr core );
  virtual ~PluginWrapper();
  
  virtual void talk( const char *_message );
};

#endif
