/*
 * k_compat.h 1.8 1995/12/03 01:26:43 (David Hinds)
 *                1998/07/12 modified by Pavel Pisa pisa@CMP.felk.cvut.cz
 */

#ifndef _LINUX_K_COMPAT_H
#define _LINUX_K_COMPAT_H

#define VERSION(v,p,s) (((v)<<16)+(p<<8)+s)

#ifndef LINUX_VERSION_CODE
  #error LINUX_VERSION_CODE not defined
#endif

#if (LINUX_VERSION_CODE < VERSION(1,3,38))

#ifdef MODULE
#include <linux/module.h>
#if !defined(CONFIG_MODVERSIONS) && !defined(__NO_VERSION__)
char kernel_version[] = UTS_RELEASE;
#endif
#else
#define MOD_DEC_USE_COUNT
#define MOD_INC_USE_COUNT
#endif

#else /* 1.3.38 */

#ifdef CONFIG_MODVERSIONS
#define MODVERSIONS 1
#if (LINUX_VERSION_CODE >= VERSION(1,3,40))
#include <linux/modversions.h>
#endif
#endif
#include <linux/module.h>

#endif /* 1.3.38 */

/* I do not know exactly date of change */
#if (LINUX_VERSION_CODE < VERSION(2,1,5))
  #define RWRET      int
  #define RWCOUNT_T  int
  #define RWINODE_P  struct inode *inode,
  #define RWPPOS_P
  #define RWINODE    inode
  #define kc_copy_from_user memcpy_fromfs
  #define kc_copy_to_user   memcpy_tofs
  #define kc_get_user_long  get_fs_long
  #define kc_get_user_word  get_fs_word
  #define kc_get_user_byte  get_fs_byte
  #define kc_put_user_long  put_fs_long
  #define kc_put_user_word  put_fs_word
  #define kc_put_user_byte  put_fs_byte
#else /* >= 2.1.5 */

  #if (LINUX_VERSION_CODE < VERSION(2,1,100)) /* may need correction */
    #include  <asm/uaccess.h>
    #define kc_copy_from_user copy_from_user
    #define kc_copy_to_user   copy_to_user
    #define kc_get_user(ptr) \
      ({ __typeof__(*(ptr)) x; \
         __get_user_check(x,(ptr),sizeof(*(ptr))); x; })
    #define kc_put_user(x,ptr) \
      (__put_user_check((x),ptr,sizeof(*(ptr))))
  #else /* >= 2.1.100 */
    #include  <asm/uaccess.h>
    #define kc_copy_from_user copy_from_user
    #define kc_copy_to_user   copy_to_user
    #define kc_get_user(ptr) \
      ({ __typeof__(*(ptr)) x; \
         get_user(x,(ptr)); x; })
    #define kc_put_user(x,ptr) \
      (put_user((x),(ptr)))
  #endif /* < 2.1.100 */

  #define kc_get_user_long(ptr)   (kc_get_user((long*)(ptr)))
  #define kc_get_user_word(ptr)   (kc_get_user((unsigned short*)(ptr)))
  #define kc_get_user_byte(ptr)   (kc_get_user((unsigned char*)(ptr)))
  #define kc_put_user_long(x,ptr) (kc_put_user((x),(long *)(ptr)))
  #define kc_put_user_word(x,ptr) (kc_put_user((x),(unsigned short*)(ptr)))
  #define kc_put_user_byte(x,ptr) (kc_put_user((x),(unsigned char*)(ptr)))

  #if (LINUX_VERSION_CODE < VERSION(2,1,36))
     #define RWRET      long
     #define RWCOUNT_T  unsigned long
     #define CLOSERET   void
     #define RWINODE_P  struct inode *inode,
     #define RWPPOS_P
     #define RWINODE    inode
  #elif (LINUX_VERSION_CODE < VERSION(2,1,76)) /* may need correction */
     #define CLOSERET   int
     #define RWRET      long
     #define RWCOUNT_T  unsigned long
     #define RWINODE_P  struct inode *inode,
     #define RWPPOS_P
     #define RWINODE    inode
  #else /* >= 2.1.76 */ /* may need correction */
     #define CLOSERET   int
     #define RWRET      ssize_t
     #define RWCOUNT_T  size_t
     #define RWINODE_P
     #define RWPPOS_P   ,loff_t *ppos
     #define RWINODE    file->f_dentry->d_inode
  #endif /* 2.1.36 */

#endif /* 2.1.5 */

/* definition of standard parameters for read/write file functions */
#define READ_PARAMETERS \
	RWINODE_P struct file *file, char *buf, RWCOUNT_T count RWPPOS_P

#define WRITE_PARAMETERS \
	RWINODE_P struct file *file, const char *buf, RWCOUNT_T count RWPPOS_P

#endif /* _LINUX_K_COMPAT_H */
