/*
 * $Id: burn_test.c,v 1.0 1998/12/28 11:26:16 magin Exp $
 *
 * $Log: burn_test.c,v $
 * Revision 1.0  1998/12/28 11:26:16  magin
 * Initial revision
 *
 */

#include	<fcntl.h>
#include	<stdio.h>
#include	<string.h>
#include	<ctype.h>
#include	<unistd.h>
#include	<stdlib.h>
#include	<sys/ioctl.h>
#include 	"bdm.h"

static void usage(char *prg)
{
	fprintf(stderr, "Usage: %s <device> <1|2|3|4> <0|1>\n", prg);
	fprintf(stderr, "   1 SDI\n");
	fprintf(stderr, "   2 SCLK\n");
	fprintf(stderr, "   3 MODE\n");
	fprintf(stderr, "   4 ISP\n");
	exit(-3);
}

int
main(int argc, char **argv)
{
int pin, level;
int fd, ioctl_arg;

	if (argc != 4) usage(argv[0]);
	if ((fd = open(argv[1], O_RDONLY)) <= 0) {
		fprintf(stderr, "device %s open error %d\n", argv[1], fd);
		exit(-4);
	}

	pin = strtol(argv[2], NULL, 0);
	level = strtol(argv[3], NULL, 0);

	ioctl_arg = (level ? BDM_isp_LEVEL : 0);

	switch (pin) {
		case 1: ioctl_arg |= BDM_ispSDI; break;
		case 2: ioctl_arg |= BDM_ispSCLK; break;
		case 3: ioctl_arg |= BDM_ispMODE; break;
		case 4: ioctl_arg |= BDM_ispISP; break;
		case 5:
			level = ioctl(fd, BDM_ISPGET, 0);
			printf("%d\n", level);
			exit(0);
			break;
		default:
			fprintf(stderr, "illegal pin %s", argv[2]);
			usage(argv[0]);
			exit(-5);
	}

	ioctl(fd, BDM_ISPSET, ioctl_arg);

	close(fd);
	return 0;
}

