/*
 * $Id: lattice.h,v 1.0 1998/12/28 11:27:55 magin Exp $
 */

#define    false                        0
#define    true                         1

#ifdef     outportb
#undef     outportb
#endif
#ifdef     inportb
#undef     inportb
#endif
#ifdef     outp
#undef     outp
#endif
#ifdef     inp
#undef     inp
#endif
#ifdef     enable
#undef     enable
#endif
#ifdef     disable
#undef     disable
#endif


#define    inport1                 0x379
#define    outport1                0x378
#define    inport2                 0x279
#define    outport2                0x278
#define    inport3                 0x3BD
#define    outport3                0x3BC

#define    ABORT                      -3
#define    UNKNOWN                    -2
#define    OUT_OF_MEMORY              -1
#define    NUL                         0

#define    OK                          0
#define    INVALID_CHIP               -4
#define    CABLE_NOT_FOUND            -5
#define    POWER_OFF                  -6
#define    CHIPS_NOT_FOUND            -7
#define    FILE_NOT_FOUND             -8
#define    FILE_NOT_VALID             -9
#define    FILE_TOO_BIG              -10
#define    VALIDATION_ERROR          -11
#define    NO_VERIFY_SEC_FUSE_SET    -12
#define    NON_ISP_PART              -13
#define    UNKNOWN_FUNCTION          -14
#define    TOO_MANY_CHIPS            -15
#define    UNKNOWN_CHIP              -16
#define    FILE_NOT_JEDEC            -17
#define    FILE_ERROR                -18
#define    FILE_UES_INVALID          -19

#define    out_SDI                     1    /* weight of output signal lines  */
#define    out_SCLK                    2
#define    out_MODE                    4
#define    out_ISP                     8
#define    out_RESET                  16
#define    out_SENSE_CABLE_OUT        64

#define    in_VCC_OK                   8    /* weight of  input signal lines  */
#define    in_CABLE_SENSE_IN          32
#define    in_SDO                     64

#define    HIGH                     0x01
#define    LOW                      0x00

/* define 5-bit command codes, using 8-bit value, with the 3 MSBs zeroed */
#define NOP                0x00 /* 00000 - No operation */

#define SHIFT_ADDRESS      0x01 /* 00001 - Enable address shift register */
#define SHIFT_DATA         0x02 /* 00010 - Enable data shift register    */
#define ARCH_SHIFT         0x14 /* 10100 - Enable arch shift for 22v10   */

#define ERASE              0x03 /* 00011 - Erase entire device, except UES */
#define ERASE_ALL          0x10 /* 10000 - Erase entire device, and UES    */

#define PROGRAM_HIGH       0x07 /* 00111 - Program high order bits       */
#define PROGRAM_LOW        0x08 /* 01000 - Program low order bits        */
#define PROGRAM_UES        0x0F /* 01111 - Program UES row               */

#define SECURE             0x09 /* 01001 - Program security cell         */

#define VERIFY_HIGH_PROG   0x0A /* 01010 - Verify high order bits are
								   programmed (JEDEC zeros)              */
#define VERIFY_LOW_PROG    0x0B /* 01011 - Verify low order bits are
								   programmed (JEDEC zeros)              */

#define VERIFY_HIGH_ERASED 0x12 /* 10010 - Verify high order bits are
								   erased (JEDEC ones)                   */
#define VERIFY_LOW_ERASED  0x13 /* 10011 - Verify low order bits are
								   erased (JEDEC ones)                   */

#define VERIFY_UES         0x11 /* 10001 - Verify/Load UES bits          */

#define FLOW_THRU          0x0E /* 01110 - Put the device in bypass mode */

/*4.00 added to support 2032LV*/
#define VERIFY_USERCODE    0x17 /* 10111 - Verify/load 2032LV 32 bits UES*/

#define PROG_USERCODE      0x1A /* 11010 - Program 2032LV 32 bits UES*/

#define BYPASS             0x1F /* 11111 - By Pass for 2032LV devices 
                                           initialize for other devices*/
#define PROGRAM_ENABLE     0x15 /* 10101 - Read 8 bits ID from devices
                                           and set devices in programming
                                           mode*/

/*4.00 for BSCAN programming support*/
#define    idle_state                  0    /* At Run-Test/Idle */
#define    shift_state                 1    /* At Shift-IR*/
#define    execute_state               2    /* At Shift-DR*/
#define    time_state                 -1    /* From Shift-IR to Run-Test/Idle*/



#define DATAROW 4   /*3.05 variable for row to start ues verify*/

#define prog_verify   0
#define verify        1
#define verify_ues    2
#define read_show_ues 3

