/*
 * $Id: morse.c,v 1.0 1998/12/28 11:25:38 magin Exp $
 *
 * $Log: morse.c,v $
 * Revision 1.0  1998/12/28 11:25:38  magin
 * Initial revision
 *
 */

#include	<fcntl.h>
#include	<stdio.h>
#include	<string.h>
#include	<ctype.h>
#include	<unistd.h>
#include	<stdlib.h>
#include	<sys/ioctl.h>
#include 	"bdm.h"

char *default_code = "... .--..--..-- --- -- -.- .-. .";

#define MORSE_SLOT  120*1000
#define	MORSE_SHORT	1*MORSE_SLOT
#define MORSE_LONG  4*MORSE_SHORT
#define MORSE_GAP   2*MORSE_SLOT
#define MORSE_PAUSE 8*MORSE_SLOT

static void usage(char *prg)
{
	fprintf(stderr, "Usage: %s <device>\n", prg);
	exit(-3);
}

static void set_led(int fd, int level)
{
	ioctl(fd, BDM_SETLED, level);
}

int
main(int argc, char **argv)
{
int fd;
char *cptr;
char *code = default_code;

	if ((argc < 2) || (argc >4)) usage(argv[0]);
	if (argc == 3) code = argv[2];
	if ((fd = open(argv[1], O_RDONLY)) <= 0) {
		fprintf(stderr, "device %s open error %d\n", argv[1], fd);
		exit(-4);
	}

	for (cptr = code; *cptr; cptr++) {
		printf("%c", *cptr); fflush(stdout);
		switch (*cptr) {
			case '.':
				set_led(fd, 1); usleep(MORSE_SHORT); 
				set_led(fd, 0); 
				break;
			case '-':
				set_led(fd, 1); usleep(MORSE_LONG); 
				set_led(fd, 0);
				break;
			case ' ':
				usleep(MORSE_PAUSE); 
				break;
			default: ;
		}
		usleep(MORSE_GAP);
	}
	printf("\n");
	close(fd);
	return 0;
}

