// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: EvSci.h
//   An event, type 'system call ingoing'.
//   This is a leaf class.
//
// File Created:	11 Apr 1995		Michael Chastain
// Last Edited:		12 Sep 1995		Michael Chastain

#if !defined(EV_SCI_H)
#define EV_SCI_H

#include <EvBase.h>
#include <MmMap.h>
#include <MmType.h>
#include <ScLine.h>
#include <WhList.h>



class	EvSci			: public EvBase
{
    // Constructor, destructor, and copier.
    public:
				EvSci		(		   );
				~EvSci		(		   );
	virtual EvBase *	copy		(		   ) const;

    // RTTI.
    public:
	const EvSci *		ptrEvSci	(		   ) const;

    // Flat interface (combiner).
    private:
	MmRet			fromFlatEv	( MmFlat &	   );
	void			toFlatEv	( MmFlat &	   ) const;

    // String interface (combiner).
    private:
	void			fmtStrEv	( WhString &	   ) const;

    // Process interface.
    public:
	MmRet			fetch		( const PrProc &,
						  const MmMap &,
						  const EvSci *	   );
	MmRet			storeAfterWait	( PrProc &,
						  const EvSci *	   ) const;
	MmRet			storeBeforeCont	( PrProc &,
						  const EvSci *	   ) const;

    // Accessors.
    public:
	MmWord			getArg		( int		   ) const;
	void			getScLine	( ScLine &	   ) const;
	MmWord			getSysEntry	(		   ) const;
	bool			hasArg		(		   ) const;

    // Instance data.
    private:
	bool			fEntry_;	// Entry # initialized.
	bool			fArg_;		// Arguments initialized.
	bool			fSeg_;		// Segments initialized.
	MmWord			wSysEntry_;	// Sys entry #.
	MmWord			wSubEntry_;	// Sub entry #.
	WhList <MmWord>		lwArg_;		// Arguments.
};



// Inline methods.

inline bool EvSci::hasArg( ) const
{
    return fArg_;
}



#endif
