// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: MmArea.cc
//   Address area class.
//   This is a concrete class.
//
// File Created:	24 Apr 1995		Michael Chastain
// Last Edited:		15 Jun 1995		Michael Chastain

#include <MmArea.h>
#include <WhAbort.h>



// Constructor.
MmArea::MmArea( )
    : tyArea_	( tyAreaBlank	)
    , addrMin_	( 0		)
    , addrMax_	( 0		)
{
    ;
}



// Constructor.
MmArea::MmArea( TyArea tyArea, MmAddr addrMin, MmAddr addrMax )
    : tyArea_	( tyArea	)
    , addrMin_	( addrMin	)
    , addrMax_	( addrMax	)
{
    if ( addrMin_ > addrMax_ )
	WhAbort( "MmArea::MmArea: bad range." );
}



// Flat input.
MmRet MmArea::fromFlat( MmFlat & flatFrom )
{
    // Read values.
    int    ityArea; MmRetCheck( flatFrom.getInt  ( ityArea ) );
    MmAddr addrMin; MmRetCheck( flatFrom.getAddr ( addrMin ) );
    MmAddr addrMax; MmRetCheck( flatFrom.getAddr ( addrMax ) );

    // Check values.
    switch ( ityArea )
    {
    default:		return MmRetRaise( mmRetFlatEnumBad );
    case tyAreaBlank:	break;
    case tyAreaUser:	break;
    case tyAreaText:	break;
    case tyAreaData:	break;
    case tyAreaBss:	break;
    case tyAreaBrk:	break;
    case tyAreaLib:	break;
    case tyAreaMmap:	break;
    case tyAreaStack:	break;
    }
    if ( addrMin > addrMax )
	return MmRetRaise( mmRetFlatAddrRange );

    // Store values.
    tyArea_  = TyArea( ityArea );
    addrMin_ = addrMin;
    addrMax_ = addrMax;

    // That's all, folks.
    return mmRetOk;
}



// Flat output.
void MmArea::toFlat( MmFlat & flatTo ) const
{
    flatTo.putInt	( int( tyArea_ ) );
    flatTo.putAddr	( addrMin_       );
    flatTo.putAddr	( addrMax_       );
}



// Set to cover the address space.
//   Fencepost error (mac->max), addrMax_ doesn't cover highest address.
void MmArea::setCover( TyArea tyArea )
{
    tyArea_  = tyArea;
    addrMin_ = mmAddrMin;
    addrMax_ = mmAddrMac;
}
