// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: MmArea.h
//   Address area class.
//   This is a concrete class.
//
// File Created:	24 Apr 1995		Michael Chastain
// Last Edited:		15 May 1995		Michael Chastain

#if !defined(MM_AREA_H)
#define MM_AREA_H

#include <MmFlat.h>
#include <MmRet.h>
#include <MmType.h>



class	MmArea
{
    // Types of areas.
    //   These values are stored in files.
    public:
	enum	TyArea
	{
	    tyAreaBlank,
	    tyAreaUser,
	    tyAreaText,
	    tyAreaData,
	    tyAreaBss,
	    tyAreaBrk,
	    tyAreaLib,
	    tyAreaMmap,
	    tyAreaStack
	};

    // Constructors.
    public:
				MmArea		(		   );
				MmArea		( TyArea,
						  MmAddr, MmAddr   );

    // Flat interface.
    public:
	MmRet			fromFlat	( MmFlat &	   );
	void			toFlat		( MmFlat &	   ) const;

    // Accessors.
    public:
	int			count		(		   ) const;
	TyArea			getTyArea	(		   ) const;
	MmAddr			getAddrMin	(		   ) const;
	MmAddr			getAddrMax	(		   ) const;

    // Mutators.
    public:
	void			setCover	( TyArea	   );

    // Instance data.
    private:
	TyArea			tyArea_;	// Type of area.
	MmAddr			addrMin_;	// Min address (inclusive).
	MmAddr			addrMax_;	// Max address (exclusive).
};



// Inline methods.

inline int MmArea::count( ) const
{
    return addrMax_ - addrMin_;
}

inline MmArea::TyArea MmArea::getTyArea( ) const
{
    return tyArea_;
}

inline MmAddr MmArea::getAddrMin( ) const
{
    return addrMin_;
}

inline MmAddr MmArea::getAddrMax( ) const
{
    return addrMax_;
}



#endif
