// Copyright 1994, 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: MmFlat.h
//   Flat data.
//   This is a concrete class.
//
// File Created:	19 Sep 1994		Michael Chastain
// Last Edited:		23 May 1995		Michael Chastain

#if !defined(MM_FLAT_H)
#define MM_FLAT_H

#include <MmRet.h>
#include <MmType.h>
#include <WhFile.h>
#include <WhList.h>
#include <WhString.h>



class	MmFlat
{
    // Constructor.
    public:
				MmFlat		(		   );

    // File interface.
    public:
	MmRet			fromFile	( WhFile &	   );
	MmRet			toFile		( WhFile &	   ) const;

    // Flat interface.
    public:
	MmRet			fromFlat	( MmFlat &	   );
	void			toFlat		( MmFlat &	   ) const;

    // Accessors.
    public:
	const WhList <char> &	getDataRaw	(		   ) const;
	const WhString &	getFileName	(		   ) const;
	bool			isAtEnd		(		   ) const;

    // Mutators.
    public:
	void			rewind		(		   );

    // Readers.
    public:
	MmRet			getAddr		( MmAddr &	   );
	MmRet			getBool		( bool &	   );
	MmRet			getInt		( int &		   );
	MmRet			getListChar	( WhList<char>   & );
	MmRet			getListWord	( WhList<MmWord> & );
	MmRet			getLong		( long &	   );
	MmRet			getString	( WhString &	   );
	MmRet			getWord		( MmWord &	   );

    // Writers.
    public:
	void			putAddr		( MmAddr	   );
	void			putBool		( bool		   );
	void			putInt		( int		   );
	void			putListChar	( const WhList
						  <char> &	   );
	void			putListWord	( const WhList
						  <MmWord> &	   );
	void			putLong		( long		   );
	void			putString	( const WhString & );
	void			putWord		( MmWord	   );

    // Instance data.
    private:
    	WhString		strFileName_;	// Name of input file.
    	int			icDataPos_;	// Read/write position.
    	WhList <char>		lcData_;	// Data.
};



// Inline methods.

inline const WhList <char> & MmFlat::getDataRaw( ) const
{
    return lcData_;
}

inline const WhString & MmFlat::getFileName( ) const
{
    return strFileName_;
}

inline bool MmFlat::isAtEnd( ) const
{
    return !lcData_.isInRange( icDataPos_ );
}

inline void MmFlat::rewind( )
{
    icDataPos_ = 0;
}



#endif
