// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: MmMap.h
//   Address map class.
//   This is a concrete class.
//
// File Created:	24 Apr 1995		Michael Chastain
// Last Edited:		04 Sep 1995		Michael Chastain

#if !defined(MM_MAP_H)
#define MM_MAP_H

#include <MmArea.h>
#include <MmType.h>
#include <WhList.h>



class	MmMap
{
    // Constructor.
    public:
				MmMap		(		   );

    // Accessors.
    public:
	int			count		(		   ) const;
	MmAddr			getAddrBrk	(		   ) const;
	MmAddr			getAddrSpMax	(		   ) const;
	const MmArea &		getArea		( int		   ) const;

    // Mutator.
    public:
	void			mergeArea	( const MmArea &   );

    // Instance data.
    private:
	WhList <MmArea>		larea_;		// List of areas.
};



// Inline methods.

inline int MmMap::count( ) const
{
    return larea_.count( );
}

inline const MmArea & MmMap::getArea( int iArea ) const
{
    return larea_[iArea];
}



#endif
