// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: MsLine.cc
//   System call line.
//   This is a concrete class.
//
// These are the methods.
//
// File Created:	29 Jul 1995		Michael Chastain
// Last Edited:		03 Sep 1995		Michael Chastain

#include <EvBase.h>
#include <EvSci.h>
#include <EvSco.h>
#include <MsLine.h>
#include <PrProc.h>
#include <WhAbort.h>



// Fetch a segment.
MmRet MsLine::fetchSeg( bool fIngoing, const PrProc & procFetch,
    const MmMap & mapFetch, const EvSci & evSciArg, const EvSco & evScoScr,
    EvBase & evTarget ) const
{
    // Check in/out.
    if ( fIngoing ? !fIngoing_ : !fOutcoming_ )
	return mmRetOk;

#if 0
    // Check condition.
    switch ( tyCond_ )
    {
    default:
	WhAbort( "MsLine::fetchSeg: bad enum." );

    case tyCondAlways:
	break;

    case tyCondArgEq:
	if ( evSciArg.getArg( iCond_ ) != wCond_ )
	    return mmRetOk;
	break;

    case tyCondArgNe:
	if ( evSciArg.getArg( iCond_ ) == wCond_ )
	    return mmRetOk;
	break;

    case tyCondNever:
	return mmRetOk;
    }
#endif

    // Get address.
    MmAddr addrSeg = 0;
    switch ( tyAddr_ )
    {
    default:
	WhAbort( "MsLine::fetchSeg: bad enum." );

    case tyAddrArg:
	addrSeg = MmAddr( evSciArg.getArg( iAddr_ ) );
	break;
    }

    // Get count.
    int nCount = 0;
    switch ( tyCount_ )
    {
    default:
	WhAbort( "MsLine::fetchSeg: bad enum." );

    case tyCountArg:
	nCount = evSciArg.getArg( nCount_ );
	break;

    case tyCountMem:
	{
	    // Need to allow unaligned access here.
	    MmWord wnCount;
	    if ( !procFetch.fetchWord( MmArea::tyAreaData,
		MmAddr( evSciArg.getArg( nCount_ ) ), wnCount, 0 ) )
	    {
		// Do not enable fetching of this segment.
	    }
	    else
	    {
		nCount = int( wnCount );
	    }
	}
	break;

    case tyCountOne:
	if ( nCount_ != 1 )
	    WhAbort( "MsLine::fetchSeg: tyCountOne." );
	nCount = 1;
	break;

    case tyCountRet:
	if ( !evScoScr.isScrError( ) )
	    nCount = int( evScoScr.getScrWord( 0 ) );
	break;
    }

    // Fetch segment.
    if ( addrSeg != 0 && nCount > 0 )
    {
	MmSeg segFetch;
	MmRetCheck( segFetch.fetchProc( procFetch, MmArea::tyAreaData, itySeg_,
	    addrSeg, nCount ) );
	evTarget.appSeg( segFetch );
    }

    // That's all, folks.
    return mmRetOk;
}
