// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: PrScr.h
//   System call return value.
//   This is a concrete class.
//
// File Created:	19 Jun 1995		Michael Chastain
// Last Edited:		22 Sep 1995		Michael Chastain

#if !defined(PR_SCR_H)
#define PR_SCR_H

#include <MmFlat.h>
#include <MmRet.h>
#include <MmType.h>
#include <PrProc.h>
#include <WhString.h>



class	PrScr
{
    // Types.
    // These values go into files.
    public:
	enum	TyScr
	{
	    tyScrAddr = 0xDADA0001,		// Address.
	    tyScrHex,				// Hexadecimal.
	    tyScrInt,				// Integer (could be errno).
	    tyScrNot,				// Return not expected!
	    tyScrOct				// Octal.
	};

    // Constructor.
    public:
				PrScr		(		   );

    // Flat interface.
    public:
	MmRet			fromFlat	( MmFlat &	   );
	void			toFlat		( MmFlat &	   ) const;

    // Process interface.
    public:
	void			fetchProc	( const PrProc &,
						  TyScr		   );
	void			storeProc	( PrProc &	   ) const;

    // Formatter.
    public:
	void			fmtScr		( WhString &	   ) const;

    // Accessors.
    public:
	MmWord			getWord		( int iWord	   ) const;
	bool			isError		(		   ) const;

    // Mutators.
    public:
	void			clear		(		   );
	void			setError	( TyScr, MmWord	   );
	void			setValue	( TyScr, MmWord,
						  MmWord	   );

    // Helpers.
    private:
	void			fmtError	( WhString &	   ) const;

    // Instance data.
    private:
	TyScr			tyScr_;		// Type.
	bool			fBound_;	// Value is bound.

#if defined(MEC_TARGET_LIX)
    // Linux 1.2.9: instance data.
    private:
	MmWord			wScr_;		// Sys call return value.
#endif

#if defined(MEC_TARGET_SUN)
    // SunOS 4.1.3: instance data.
    private:
	MmWord			wError_;	// 'u_error' (plus stuff).
	MmWord			w1_;		// 'u_rval1'.
	MmWord			w2_;		// 'u_rval2'.
#endif

};



// Inline methods.

inline void PrScr::clear( )
{
    tyScr_  = tyScrNot;
    fBound_ = false;
}



#endif
