// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: PrTime.cc
//   Time of day class.
//   This is a concrete class.
//
// File Created:	24 Feb 1995		Michael Chastain
// Last Edited:		22 Sep 1995		Michael Chastain

#include <sys/time.h>
#include <errno.h>
#include <unistd.h>

#if defined(MEC_TARGET_SUN)
#include <FixHeadSun.h>
#endif

#include <PrTime.h>
#include <WhAbort.h>



// Constructor.
PrTime::PrTime( )
    : iSecond_	(0)
    , iMicro_	(0)
{
    ;
}



// Flat input.
MmRet PrTime::fromFlat( MmFlat & flatFrom )
{
    MmRetCheck( flatFrom.getLong( iSecond_ ) );
    MmRetCheck( flatFrom.getLong( iMicro_  ) );
    return mmRetOk;
}



// Flat output.
void PrTime::toFlat( MmFlat & flatTo ) const
{
    flatTo.putLong( iSecond_ );
    flatTo.putLong( iMicro_  );
}



// Mark with current time.
void PrTime::mark( )
{
    struct timeval timeval;

    ::errno = 0;
    ::gettimeofday( &timeval, 0 );
    if ( ::errno != 0 )
	WhAbort( "PrTime::mark: failed gettimeofday." );

    iSecond_ = timeval.tv_sec;
    iMicro_  = timeval.tv_usec;
}
