// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: PrTime.h
//   Time of day class.
//   This is a concrete class.
//
// File Created:	24 Feb 1995		Michael Chastain
// Last Edited:		21 Apr 1995		Michael Chastain

#if !defined(PR_TIME_H)
#define PR_TIME_H

#include <MmFlat.h>
#include <MmRet.h>



class	PrTime
{
    // Constructor.
    public:
				PrTime		(		   );

    // Flat interface.
    public:
	MmRet			fromFlat	( MmFlat &	   );
	void			toFlat		( MmFlat &	   ) const;

    // Accessors.
    public:
	long			getSecond	(		   ) const;
	long			getMicro	(		   ) const;

    // Mutators.
    public:
	void			mark		(		   );

    // Instance data.
    private:
	long			iSecond_;	// From 'gettimeofday(2)'.
	long			iMicro_;	// From 'gettimeofday(2)'.
};



// Inline methods.

inline long PrTime::getSecond( ) const
{
    return iSecond_;
}

inline long PrTime::getMicro( ) const
{
    return iMicro_;
}

#endif
