// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: ReplayArg.cc
//   Argument holder.
//   This is a concrete class.
//
// File Created:	30 Apr 1995		Michael Chastain
// Last Edited:		29 Jun 1995		Michael Chastain

#include <stdio.h>
#include <string.h>

#include <WhAbort.h>
#include <ReplayArg.h>



// Constructor.
ReplayArg::ReplayArg( int argc, const char * const * argv,
    const char * const * envp )
    : fError_		( false	)
    , fHelp_		( false	)
    , fNoEffect_	( false	)
    , strFileIn_	(	)
    , argv_		( argv	)
    , envp_		( envp	)
{
    // Validate arguments.
    if ( argc < 1 || argv == 0 || envp == 0 )
	WhAbort( "ReplayArg::ReplayArg: arguments bad." );

    // Collect flags.
    int iargFlag;
    for ( iargFlag = 1; argv[iargFlag] != 0; ++iargFlag )
    {
	// Grab the flag arg.
	const char * pstrFlag = argv[iargFlag];

	// Recognize flags.
	if      ( ::strcmp( pstrFlag, "--" ) == 0 ) { ++iargFlag; break;      }
	else if ( ::strcmp( pstrFlag, "-h" ) == 0 ) { fHelp_     = true;      }
	else if ( ::strcmp( pstrFlag, "-n" ) == 0 ) { fNoEffect_ = true;      }
	else if ( pstrFlag[0] == '-' )
	{
	    fError_ = true;
	    return;
	}
	else
	{
	    break;
	}
    }

    // Require exactly one more argument.
    if ( !fHelp_ )
    {
	if ( argv[iargFlag] == 0 || argv[iargFlag+1] != 0 )
	    fError_ = true;
	else
	    strFileIn_ = WhString( argv[iargFlag] );
    }
}



// Show usage.
void ReplayArg::showUsage( const char * pstrVersion ) const
{
    const char * pstrName = 
	(argv_ != 0 && argv_[0] != 0) ? argv_[0] : "<noname>";

    ::printf(
	"%s version %s (" __DATE__ ").\n"
	"Usage: %s [flags ...] trace-file\n"
	"         -h           show this usage message\n"
	"         -n           no effect (list only)\n"
	"         trace-file   file of trace data\n"
	, pstrName, pstrVersion, pstrName );
}
