// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: ReplayArg.h
//   Argument holder.
//   This is a concrete class.
//
// File Created:	05 Feb 1995		Michael Chastain
// Last Edited:		29 Jun 1995		Michael Chastain

#if !defined(REPLAY_ARG_H)
#define REPLAY_ARG_H

#include <WhString.h>



class	ReplayArg
{
    // Constructor.
    public:
				ReplayArg	( int,
						  const char * const *,
						  const char * const *
						  		   );
    // Usage interface.
    public:
	void			showUsage	( const char *	   ) const;

    // Accessors.
    public:
	bool			isError		(		   ) const;
	bool			hasHelp		(		   ) const;
	bool			hasNoEffect	(		   ) const;
	const WhString &	getFileIn	(		   ) const;

    // Instance data.
    private:
	bool			fError_;	// Args have error.
	bool			fHelp_;		// '-h'.
	bool			fNoEffect_;	// '-n'.
	WhString		strFileIn_;	// 'file'.
	const char * const *	argv_;		// Original 'argv'.
	const char * const *	envp_;		// Original 'envp'.
};



// Inline methods.

inline bool ReplayArg::isError( ) const
{
    return fError_;
}

inline bool ReplayArg::hasHelp( ) const
{
    return fHelp_;
}

inline bool ReplayArg::hasNoEffect( ) const
{
    return fNoEffect_;
}

inline const WhString & ReplayArg::getFileIn( ) const
{
    return strFileIn_;
}



#endif
