// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: ScLineLix.cc
//   System call line.
//   This is a struct.
//
// This is the data table.
//
// File Created:	10 Apr 1995		Michael Chastain
// Last Edited:		17 Sep 1995		Michael Chastain



// System header files.
#include <FixHeadLix.h>
#include <linux/types.h>
#include <linux/cdrom.h>
#include <linux/dirent.h>
#include <linux/fcntl.h>
#include <linux/fd.h>
#include <linux/if.h>
#include <linux/if_eql.h>
#include <linux/kd.h>
#include <linux/mman.h>
#include <linux/net.h>
#include <linux/ptrace.h>
#include <linux/route.h>
#include <linux/scsi.h>
#include <linux/socket.h>
#include <linux/sockios.h>
#include <linux/termios.h>
#include <linux/uio.h>
#include <linux/unistd.h>


// More system header files.
#define  __KERNEL__
#include <linux/linkage.h>
#include <linux/ipc.h>
#include <linux/msg.h>
#include <linux/sem.h>
#include <linux/shm.h>
#undef   __KERNEL__



// My header files.
#include <EvBase.h>
#include <EvSci.h>
#include <EvSco.h>
#include <Exe.h>
#include <MmArea.h>
#include <MmMap.h>
#include <MmFlat.h>
#include <MmSeg.h>
#include <MmType.h>
#include <PrProc.h>
#include <RiLine.h>
#include <ScLine.h>
#include <TySegEnumLix.h>
#include <WhAbort.h>
#include <WhCount.h>
#include <WhFile.h>
#include <WhList.h>



// Seg fetchers.
MmRet	FetchAllArea		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchOutBdflush		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchOutBrk		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchInExecve		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchOutExecve		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchInFcntl		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchOutFcntl		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchInInitModule	( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchInIoctl		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchOutIoctl		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchOutMmap		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchInModifyLdt	( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchOutModifyLdt	( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchInMount		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchOutMprotect	( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchInMsgctl		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchOutMsgctl		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchOutMsgrcv0		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchOutMsgrcv1		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchInMsgsnd		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchOutMunmap		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchInNewselect	( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchOutNewselect	( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchOutPtrace		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchOutRead		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchOutReaddir		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchOutRecv		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchOutRecvfrom	( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchInRecvmsg		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchOutRecvmsg		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchInSelect		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchOutSelect		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchInSemctl		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchOutSemctl		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchInSendmsg		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchInShmctl		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchOutShmctl		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchInSigreturn	( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchInSysfs		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchOutSysfs		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchOutSyslog		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchInUselib		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );
MmRet	FetchOutUselib		( const PrProc &, const MmMap &, const EvSci &, const EvSco &, EvBase & );



// Make initializers available.
#define	tyAddrArg		MsLine::tyAddrArg
#define	tyArgMem		ScLine::tyArgMem
#define	tyArgReg		ScLine::tyArgReg
#define	tyCountArg		MsLine::tyCountArg
#define	tyCountMem		MsLine::tyCountMem
#define	tyCountOne		MsLine::tyCountOne
#define	tyCountRet		MsLine::tyCountRet
#define	tyScrAddr		PrScr::tyScrAddr
#define	tyScrHex		PrScr::tyScrHex
#define	tyScrInt		PrScr::tyScrInt
#define	tyScrNot		PrScr::tyScrNot
#define	tyScrOct		PrScr::tyScrOct
#define	tySmashCant		ScLine::tySmashCant
#define	tySmashDef		ScLine::tySmashDef
#define	tySmashFile0		ScLine::tySmashFile0
#define	tySmashMmap		ScLine::tySmashMmap
#define	tySmashMpi0		ScLine::tySmashMpi0
#define	tySmashNop		ScLine::tySmashNop
#define	tySmashPair		ScLine::tySmashPair
#define	tySmashReplay		ScLine::tySmashReplay
#define	tySmashZero		ScLine::tySmashZero



// System call lines.

static const MsLine	lmsAccept		[ ] =
{
    { true,  true,  tySegMmWord,	tyAddrArg, 2,	tyCountOne, 1	},
    { false, true,  tySegListMmByte,	tyAddrArg, 1,	tyCountMem, 2	}
};

static const ScLine	sclAccept		=
{
    "accept", true, tyArgMem, 1, "DPP", tySmashDef, tyScrInt,
    lmsAccept, WhCount(lmsAccept), 0, 0,
};



static const MsLine	lmsAccess		[ ] =
{
    { true,  false, tySegStrNul,	tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclAccess		=
{
    "access", true, tyArgReg, 0, "PD", tySmashDef, tyScrInt,
    lmsAccess, WhCount(lmsAccess), 0, 0
};



static const MsLine	lmsAcct			[ ] =
{
    { true,  false, tySegStrNul,	tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclAcct			=
{
    "acct", true, tyArgReg, 0, "P", tySmashDef, tyScrInt,
    lmsAcct, WhCount(lmsAcct), 0, 0
};



static const MsLine	lmsAdjtimex		[ ] =
{
    { true,  true,  tySegTimex,		tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclAdjtimex		=
{
    "adjtimex", true, tyArgReg, 0, "P", tySmashDef, tyScrInt,
    lmsAdjtimex, WhCount(lmsAdjtimex), 0, 0
};



static const ScLine	sclAlarm		=
{
    "alarm", true, tyArgReg, 0, "D", tySmashZero, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclBdflush		=
{
    "bdflush", true, tyArgReg, 0, "DP", tySmashMpi0, tyScrInt,
    0, 0, 0, FetchOutBdflush
};



static const MsLine	lmsBind			[ ] =
{
    { true,  false, tySegListMmByte,	tyAddrArg, 1,	tyCountArg, 2	}
};

static const ScLine	sclBind			=
{
    "bind", true, tyArgMem, 1, "DPD", tySmashDef, tyScrInt,
    lmsBind, WhCount(lmsBind), 0, 0
};



static const ScLine	sclBreak		=
{
    "break", true, tyArgReg, 0, "", tySmashNop, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclBrk			=
{
    "brk", true, tyArgReg, 0, "P", tySmashReplay, tyScrAddr,
    0, 0, 0, FetchOutBrk
};



static const MsLine	lmsChdir		[ ] =
{
    { true,  false, tySegStrNul,	tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclChdir		=
{
    "chdir", true, tyArgReg, 0, "P", tySmashDef, tyScrInt,
    lmsChdir, WhCount(lmsChdir), 0, 0
};



static const MsLine	lmsChmod		[ ] =
{
    { true,  false, tySegStrNul,	tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclChmod		=
{
    "chmod", true, tyArgReg, 0, "PO", tySmashDef, tyScrInt,
    lmsChmod, WhCount(lmsChmod), 0, 0
};



static const MsLine	lmsChown		[ ] =
{
    { true,  false, tySegStrNul,	tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclChown		=
{
    "chown", true, tyArgReg, 0, "PDD", tySmashDef, tyScrInt,
    lmsChown, WhCount(lmsChown), 0, 0
};



static const MsLine	lmsChroot		[ ] =
{
    { true,  false, tySegStrNul,	tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclChroot		=
{
    "chroot", true, tyArgReg, 0, "P", tySmashDef, tyScrInt,
    lmsChroot, WhCount(lmsChroot), 0, 0
};



static const ScLine	sclClone		=
{
    "clone", true, tyArgReg, 0, "PX", tySmashCant, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclClose		=
{
    "close", true, tyArgReg, 0, "D", tySmashDef, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	lmsConnect		[ ] =
{
    { true,  false, tySegListMmByte,	tyAddrArg, 1,	tyCountArg, 2	}
};

static const ScLine	sclConnect		=
{
    "connect", true, tyArgMem, 1, "DPD", tySmashDef, tyScrInt,
    lmsConnect, WhCount(lmsConnect), 0, 0
};



static const MsLine	lmsCreat		[ ] =
{
    { true,  false, tySegStrNul,	tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclCreat		=
{
    "creat", true, tyArgReg, 0, "PO", tySmashDef, tyScrInt,
    lmsCreat, WhCount(lmsCreat), 0, 0
};



static const MsLine	lmsCreateModule		[ ] =
{
    { true,  false, tySegStrNul,	tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclCreateModule		=
{
    "create_module", true, tyArgReg, 0, "PD", tySmashDef, tyScrInt,
    lmsCreateModule, WhCount(lmsCreateModule), 0, 0
};



static const MsLine	lmsDeleteModule		[ ] =
{
    { true,  false, tySegStrNul,	tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclDeleteModule		=
{
    "delete_module", true, tyArgReg, 0, "P", tySmashDef, tyScrInt,
    lmsDeleteModule, WhCount(lmsDeleteModule), 0, 0
};



static const ScLine	sclDup			=
{
    "dup", true, tyArgReg, 0, "D", tySmashDef, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclDup2			=
{
    "dup2", true, tyArgReg, 0, "DD", tySmashDef, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	lmsExecve		[ ] =
{
    { true,  false, tySegStrNul,	tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclExecve		=
{
    "execve", true, tyArgReg, 0, "PPP", tySmashFile0, tyScrInt,
    lmsExecve, WhCount(lmsExecve), FetchInExecve, FetchOutExecve
};



static const ScLine	sclExit			=
{
    "exit", true, tyArgReg, 0, "D", tySmashReplay, tyScrNot,
    0, 0, 0, 0
};



static const ScLine	sclFchdir		=
{
    "fchdir", true, tyArgReg, 0, "D", tySmashDef, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclFchmod		=
{
    "fchmod", true, tyArgReg, 0, "DO", tySmashDef, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclFchown		=
{
    "fchown", true, tyArgReg, 0, "DDD", tySmashDef, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclFcntl		=
{
    "fcntl", true, tyArgReg, 0, "DDP", tySmashDef, tyScrInt,
    0, 0, FetchInFcntl, FetchOutFcntl
};



static const ScLine	sclFlock		=
{
    "flock", true, tyArgReg, 0, "DX", tySmashDef, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclFork			=
{
    "fork", true, tyArgReg, 0, "", tySmashCant, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	lmsFstat		[ ] =
{
    { false, true,  tySegNewStat,	tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclFstat		=
{
    "fstat", true, tyArgReg, 0, "DP", tySmashDef, tyScrInt,
    lmsFstat, WhCount(lmsFstat), 0, 0
};



static const MsLine	lmsFstatfs		[ ] =
{
    { false, true,  tySegStatfs,	tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclFstatfs		=
{
    "fstatfs", true, tyArgReg, 0, "DP", tySmashDef, tyScrInt,
    lmsFstatfs, WhCount(lmsFstatfs), 0, 0
};



static const ScLine	sclFsync		=
{
    "fsync", true, tyArgReg, 0, "D", tySmashDef, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclFtime		=
{
    "ftime", true, tyArgReg, 0, "", tySmashNop, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclFtruncate		=
{
    "ftruncate", true, tyArgReg, 0, "DD", tySmashDef, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	lmsGetdents		[ ] =
{
    { false, true,  tySegListDirent,	tyAddrArg, 1,	tyCountRet, 1	}
};

static const ScLine	sclGetdents		=
{
    "getdents", true, tyArgReg, 0, "DPD", tySmashDef, tyScrInt,
    lmsGetdents, WhCount(lmsGetdents), 0, 0
};



static const MsLine	lmsGetKernelSyms	[ ] =
{
    { false, true,  tySegListKernelSym,	tyAddrArg, 0,	tyCountRet, 1	}
};

static const ScLine	sclGetKernelSyms	=
{
    "get_kernel_syms", true, tyArgReg, 0, "P", tySmashDef, tyScrInt,
    lmsGetKernelSyms, WhCount(lmsGetKernelSyms), 0, 0
};



static const ScLine	sclGetegid		=
{
    "getegid", true, tyArgReg, 0, "", tySmashNop, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclGeteuid		=
{
    "geteuid", true, tyArgReg, 0, "", tySmashNop, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclGetgid		=
{
    "getgid", true, tyArgReg, 0, "", tySmashNop, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	lmsGetgroups		[ ] =
{
    { false, true,  tySegListGidT,	tyAddrArg, 1,	tyCountArg, 0	}
};

static const ScLine	sclGetgroups		=
{
    "getgroups", true, tyArgReg, 0, "DP", tySmashZero, tyScrInt,
    lmsGetgroups, WhCount(lmsGetgroups), 0, 0
};



static const MsLine	lmsGetitimer		[ ] =
{
    { false, true,  tySegItimerval,	tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclGetitimer		=
{
    "getitimer", true, tyArgReg, 0, "DP", tySmashDef, tyScrInt,
    lmsGetitimer, WhCount(lmsGetitimer), 0, 0
};



static const MsLine	lmsGetpeername		[ ] =
{
    { true,  true,  tySegMmWord,	tyAddrArg, 2,	tyCountOne, 1	},
    { false, true,  tySegListMmByte,	tyAddrArg, 1,	tyCountMem, 2	}
};

static const ScLine	sclGetpeername		=
{
    "getpeername", true, tyArgMem, 1, "DPP", tySmashDef, tyScrInt,
    lmsGetpeername, WhCount(lmsGetpeername), 0, 0
};



static const ScLine	sclGetpgid		=
{
    "getpgid", true, tyArgReg, 0, "D", tySmashDef, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclGetpgrp		=
{
    "getpgrp", true, tyArgReg, 0, "", tySmashNop, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclGetpid		=
{
    "getpid", true, tyArgReg, 0, "", tySmashNop, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclGetppid		=
{
    "getppid", true, tyArgReg, 0, "", tySmashNop, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclGetpriority		=
{
    "getpriority", true, tyArgReg, 0, "DD", tySmashDef, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	lmsGetrlimit		[ ] =
{
    { false, true,  tySegRlimit,	tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclGetrlimit		=
{
    "getrlimit", true, tyArgReg, 0, "DP", tySmashPair, tyScrInt,
    lmsGetrlimit, WhCount(lmsGetrlimit), 0, 0
};



static const MsLine	lmsGetrusage		[ ] =
{
    { false, true,  tySegRusage,	tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclGetrusage		=
{
    "getrusage", true, tyArgReg, 0, "DP", tySmashPair, tyScrInt,
    lmsGetrusage, WhCount(lmsGetrusage), 0, 0
};



static const MsLine	lmsGetsockname		[ ] =
{
    { true,  true,  tySegMmWord,	tyAddrArg, 2,	tyCountOne, 1	},
    { false, true,  tySegListMmByte,	tyAddrArg, 1,	tyCountMem, 2	}
};

static const ScLine	sclGetsockname		=
{
    "getsockname", true, tyArgMem, 1, "DPP", tySmashDef, tyScrInt,
    lmsGetsockname, WhCount(lmsGetsockname), 0, 0
};



static const MsLine	lmsGetsockopt		[ ] =
{
    { true,  true,  tySegMmWord,	tyAddrArg, 4,	tyCountOne, 1	},
    { false, true,  tySegListMmByte,	tyAddrArg, 3,	tyCountMem, 4	}
};

static const ScLine	sclGetsockopt		=
{
    "getsockopt", true, tyArgMem, 1, "DDDPP", tySmashDef, tyScrInt,
    lmsGetsockopt, WhCount(lmsGetsockopt), 0, 0
};



static const MsLine	lmsGettimeofday		[ ] =
{
    { false, true,  tySegTimeval,	tyAddrArg, 0,	tyCountOne, 1	},
    { false, true,  tySegTimezone,	tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclGettimeofday		=
{
    "gettimeofday", true, tyArgReg, 0, "PP", tySmashPair, tyScrInt,
    lmsGettimeofday, WhCount(lmsGettimeofday), 0, 0
};



static const ScLine	sclGetuid		=
{
    "getuid", true, tyArgReg, 0, "", tySmashNop, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclGtty			=
{
    "gtty", true, tyArgReg, 0, "", tySmashNop, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclIdle			=
{
    "idle", true, tyArgReg, 0, "", tySmashNop, tyScrInt,
    0, 0, 0, 0
};



// Linux 1.3.6: doesn't need text segment (yet).

static const MsLine	lmsInitModule		[ ] =
{
    { true,  false, tySegStrNul,	tyAddrArg, 0,	tyCountOne, 1	},
    { true,  false, tySegListMmByte,	tyAddrArg, 1,	tyCountArg, 2	},
    { true,  false, tySegModRoutines,	tyAddrArg, 3,	tyCountOne, 1	}
};

static const ScLine	sclInitModule		=
{
    "init_module", true, tyArgReg, 0, "PPDPP", tySmashDef, tyScrInt,
    lmsInitModule, WhCount(lmsInitModule), FetchInInitModule, 0
};



static const ScLine	sclIoctl		=
{
    "ioctl", true, tyArgReg, 0, "DXP", tySmashDef, tyScrInt,
    0, 0, FetchInIoctl, FetchOutIoctl
};



static const ScLine	sclIoperm		=
{
    "ioperm", true, tyArgReg, 0, "XDD", tySmashReplay, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclIopl			=
{
    "iopl", true, tyArgReg, 0, "D", tySmashReplay, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclKill			=
{
    "kill", true, tyArgReg, 0, "DD", tySmashPair, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	lmsLink			[ ] =
{
    { true,  false, tySegStrNul,	tyAddrArg, 0,	tyCountOne, 1	},
    { true,  false, tySegStrNul,	tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclLink			=
{
    "link", true, tyArgReg, 0, "PP", tySmashPair, tyScrInt,
    lmsLink, WhCount(lmsLink), 0, 0
};



static const ScLine	sclListen		=
{
    "listen", true, tyArgMem, 1, "DD", tySmashDef, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	lmsLlseek		[ ] =
{
    { false, true,  tySegMmLoff,	tyAddrArg, 3,	tyCountOne, 1	}
};

static const ScLine	sclLlseek		=
{
    "llseek", true, tyArgReg, 0, "DXXPD", tySmashDef, tyScrInt,
    lmsLlseek, WhCount(lmsLlseek), 0, 0
};



static const ScLine	sclLock			=
{
    "lock", true, tyArgReg, 0, "", tySmashNop, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclLseek		=
{
    "lseek", true, tyArgReg, 0, "DXD", tySmashDef, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	lmsLstat		[ ] =
{
    { true,  false, tySegStrNul,	tyAddrArg, 0,	tyCountOne, 1	},
    { false, true,  tySegNewStat,	tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclLstat		=
{
    "lstat", true, tyArgReg, 0, "PP", tySmashDef, tyScrInt,
    lmsLstat, WhCount(lmsLstat), 0, 0
};



static const MsLine	lmsMkdir		[ ] =
{
    { true,  false, tySegStrNul,	tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclMkdir		=
{
    "mkdir", true, tyArgReg, 0, "PO", tySmashDef, tyScrInt,
    lmsMkdir, WhCount(lmsMkdir), 0, 0
};



static const MsLine	lmsMknod		[ ] =
{
    { true,  false, tySegStrNul,	tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclMknod		=
{
    "mknod", true, tyArgReg, 0, "POX", tySmashDef, tyScrInt,
    lmsMknod, WhCount(lmsMknod), 0, 0
};



static const ScLine	sclMmap			=
{
    "mmap", true, tyArgMem, 0, "PDDDDD", tySmashMmap, tyScrAddr,
    0, 0, 0, FetchOutMmap
};



static const ScLine	sclModifyLdt		=
{
    "modify_ldt", true, tyArgReg, 0, "DP", tySmashDef, tyScrInt,
    0, 0, FetchInModifyLdt, FetchOutModifyLdt
};



static const MsLine	lmsMount		[ ] =
{
    { true,  false, tySegStrNul,	tyAddrArg, 0,	tyCountOne, 1	},
    { true,  false, tySegStrNul,	tyAddrArg, 1,	tyCountOne, 1	},
    { true,  false, tySegStrNul,	tyAddrArg, 2,	tyCountOne, 1	}
};

static const ScLine	sclMount		=
{
    "mount", true, tyArgReg, 0, "PPPXP", tySmashDef, tyScrInt,
    lmsMount, WhCount(lmsMount), FetchInMount, 0
};



static const ScLine	sclMprotect		=
{
    "mprotect", true, tyArgReg, 0, "PDD", tySmashReplay, tyScrInt,
    0, 0, 0, FetchOutMprotect
};



static const ScLine	sclMpx			=
{
    "mpx", true, tyArgReg, 0, "", tySmashNop, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclMsgctl		=
{
    "msgctl", true, tyArgReg, 0, "-DD-P", tySmashDef, tyScrInt,
    0, 0, FetchInMsgctl, FetchOutMsgctl
};



static const ScLine	sclMsgget		=
{
    "msgget", true, tyArgReg, 0, "-XD", tySmashDef, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	lmsMsgrcv0		[ ] =
{
    { true,  false, tySegIpcKludge,	tyAddrArg, 4,	tyCountOne, 1	}
};

static const ScLine	sclMsgrcv0		=
{
    "msgrcv-0", true, tyArgReg, 0, "-DDDP", tySmashDef, tyScrInt,
    lmsMsgrcv0, WhCount(lmsMsgrcv0), 0, FetchOutMsgrcv0
};



static const ScLine	sclMsgrcv1		=
{
    "msgrcv-1", true, tyArgReg, 0, "-DDDPD", tySmashDef, tyScrInt,
    0, 0, 0, FetchOutMsgrcv1
};



static const ScLine	sclMsgsnd		=
{
    "msgsnd", true, tyArgReg, 0, "-DDDP", tySmashDef, tyScrInt,
    0, 0, FetchInMsgsnd, 0
};



static const ScLine	sclMsync		=
{
    "msync", true, tyArgReg, 0, "PDX", tySmashNop, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclMunmap		=
{
    "munmap", true, tyArgReg, 0, "PD", tySmashReplay, tyScrInt,
    0, 0, 0, FetchOutMunmap
};



static const ScLine	sclNewselect		=
{
    "newselect", true, tyArgReg, 0, "DPPPP", tySmashDef, tyScrInt,
    0, 0, FetchInNewselect, FetchOutNewselect
};



static const ScLine	sclNice			=
{
    "nice", true, tyArgReg, 0, "D", tySmashZero, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	lmsOldfstat		[ ] =
{
    { false, true,  tySegOldStat,	tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclOldfstat		=
{
    "oldfstat", true, tyArgReg, 0, "DP", tySmashDef, tyScrInt,
    lmsOldfstat, WhCount(lmsOldfstat), 0, 0
};



static const MsLine	lmsOldlstat		[ ] =
{
    { true,  false, tySegStrNul,	tyAddrArg, 0,	tyCountOne, 1	},
    { false, true,  tySegOldStat,	tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclOldlstat		=
{
    "oldlstat", true, tyArgReg, 0, "PP", tySmashDef, tyScrInt,
    lmsOldlstat, WhCount(lmsOldlstat), 0, 0
};



static const MsLine	lmsOldolduname		[ ] =
{
    { false, true,  tySegOldoldUtsname,	tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclOldolduname		=
{
    "oldolduname", true, tyArgReg, 0, "P", tySmashDef, tyScrInt,
    lmsOldolduname, WhCount(lmsOldolduname), 0, 0
};



static const MsLine	lmsOldstat		[ ] =
{
    { true,  false, tySegStrNul,	tyAddrArg, 0,	tyCountOne, 1	},
    { false, true,  tySegOldStat,	tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclOldstat		=
{
    "oldstat", true, tyArgReg, 0, "PP", tySmashDef, tyScrInt,
    lmsOldstat, WhCount(lmsOldstat), 0, 0
};



static const MsLine	lmsOlduname		[ ] =
{
    { false, true,  tySegOldUtsname,	tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclOlduname		=
{
    "olduname", true, tyArgReg, 0, "P", tySmashDef, tyScrInt,
    lmsOlduname, WhCount(lmsOlduname), 0, 0
};



static const MsLine	lmsOpen			[ ] =
{
    { true,  false, tySegStrNul,	tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclOpen			=
{
    "open", true, tyArgReg, 0, "POO", tySmashDef, tyScrInt,
    lmsOpen, WhCount(lmsOpen), 0, 0
};



static const ScLine	sclPause		=
{
    "pause", true, tyArgReg, 0, "", tySmashCant, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclPersonality		=
{
    "personality", true, tyArgReg, 0, "D", tySmashNop, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclPhys			=
{
    "phys", true, tyArgReg, 0, "DPDP", tySmashCant, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	lmsPipe			[ ] =
{
    { false, true,  tySegMmWord2,	tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclPipe			=
{
    "pipe", true, tyArgReg, 0, "P", tySmashDef, tyScrInt,
    lmsPipe, WhCount(lmsPipe), 0, 0
};



static const ScLine	sclProf			=
{
    "prof", true, tyArgReg, 0, "", tySmashCant, tyScrInt,
    0, 0, 0, 0
};



// Linux 1.3.6: not implemented in kernel.

static const ScLine	sclProfil		=
{
    "profil", true, tyArgReg, 0, "PDPX", tySmashCant, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclPtrace		=
{
    "ptrace", true, tyArgReg, 0, "DDPP", tySmashDef, tyScrInt,
    0, 0, 0, FetchOutPtrace
};



// Linux 1.3.11: not implemented in kernel.

static const ScLine	sclQuotactl		=
{
    "quotactl", true, tyArgReg, 0, "", tySmashCant, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclRead			=
{
    "read", true, tyArgReg, 0, "DPD", tySmashDef, tyScrInt,
    0, 0, 0, FetchOutRead
};



static const ScLine	sclReaddir		=
{
    "readdir", true, tyArgReg, 0, "DPD", tySmashDef, tyScrInt,
    0, 0, 0, FetchOutReaddir
};



static const MsLine	lmsReadlink		[ ] =
{
    { true,  false, tySegStrNul,	tyAddrArg, 0,	tyCountOne, 1	},
    { false, true,  tySegStrCount,	tyAddrArg, 1,	tyCountRet, 1	}
};

static const ScLine	sclReadlink		=
{
    "readlink", true, tyArgReg, 0, "PPD", tySmashDef, tyScrInt,
    lmsReadlink, WhCount(lmsReadlink), 0, 0
};



static const ScLine	sclReboot		=
{
    "reboot", true, tyArgReg, 0, "XDX", tySmashDef, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclRecv			=
{
    "recv", true, tyArgMem, 1, "DPDD", tySmashDef, tyScrInt,
    0, 0, 0, FetchOutRecv
};



static const MsLine	lmsRecvfrom		[ ] =
{
    { true,  true,  tySegMmWord,	tyAddrArg, 5,	tyCountOne, 1	},
    { false, true,  tySegListMmByte,	tyAddrArg, 4,	tyCountMem, 5	}
};

static const ScLine	sclRecvfrom		=
{
    "recvfrom", true, tyArgMem, 1, "DPDDPP", tySmashDef, tyScrInt,
    lmsRecvfrom, WhCount(lmsRecvfrom), 0, FetchOutRecvfrom
};



static const MsLine	lmsRecvmsg		[ ] =
{
    { true,  true,  tySegMsghdr,	tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclRecvmsg		=
{
    "recvmsg", true, tyArgMem, 1, "DPD", tySmashDef, tyScrInt,
    lmsRecvmsg, WhCount(lmsRecvmsg), FetchInRecvmsg, FetchOutRecvmsg
};



static const MsLine	lmsRename		[ ] =
{
    { true,  false, tySegStrNul,	tyAddrArg, 0,	tyCountOne, 1	},
    { true,  false, tySegStrNul,	tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclRename		=
{
    "rename", true, tyArgReg, 0, "PP", tySmashPair, tyScrInt,
    lmsRename, WhCount(lmsRename), 0, 0
};



static const MsLine	lmsRmdir		[ ] =
{
    { true,  false, tySegStrNul,	tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclRmdir		=
{
    "rmdir", true, tyArgReg, 0, "P", tySmashDef, tyScrInt,
    lmsRmdir, WhCount(lmsRmdir), 0, 0
};



static const ScLine	sclSelect		=
{
    "select", true, tyArgMem, 0, "DPPPP", tySmashDef, tyScrInt,
    0, 0, FetchInSelect, FetchOutSelect
};



static const MsLine	lmsSemctl		[ ] =
{
    { true,  false, tySegSemun,		tyAddrArg, 4,	tyCountOne, 1	}
};

static const ScLine	sclSemctl		=
{
    "semctl", true, tyArgReg, 0, "-DDDP", tySmashDef, tyScrInt,
    lmsSemctl, WhCount(lmsSemctl), FetchInSemctl, FetchOutSemctl
};



static const ScLine	sclSemget		=
{
    "semget", true, tyArgReg, 0, "-XDO", tySmashDef, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	lmsSemop		[ ] =
{
    { true,  false, tySegListSembuf,	tyAddrArg, 0,	tyCountArg, 2	}
};

static const ScLine	sclSemop		=
{
    "semop", true, tyArgReg, 0, "-DD-P", tySmashDef, tyScrInt,
    lmsSemop, WhCount(lmsSemop), 0, 0
};



static const MsLine	lmsSend			[ ] =
{
    { true,  false, tySegStrCount,	tyAddrArg, 1,	tyCountArg, 2	}
};

static const ScLine	sclSend			=
{
    "send", true, tyArgMem, 1, "DPDD", tySmashDef, tyScrInt,
    lmsSend, WhCount(lmsSend), 0, 0
};



static const MsLine	lmsSendmsg		[ ] =
{
    { true,  false, tySegMsghdr,	tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclSendmsg		=
{
    "sendmsg", true, tyArgMem, 1, "DPD", tySmashDef, tyScrInt,
    lmsSendmsg, WhCount(lmsSendmsg), FetchInSendmsg, 0
};



static const MsLine	lmsSendto		[ ] =
{
    { true,  false, tySegStrCount,	tyAddrArg, 1,	tyCountArg, 2	},
    { true,  false, tySegListMmByte,	tyAddrArg, 4,	tyCountArg, 5	}
};

static const ScLine	sclSendto		=
{
    "sendto", true, tyArgMem, 1, "DPDDPD", tySmashDef, tyScrInt,
    lmsSendto, WhCount(lmsSendto), 0, 0
};



static const MsLine	lmsSetdomainname	[ ] =
{
    { true,  false, tySegStrCount,	tyAddrArg, 0,	tyCountArg, 1	}
};

static const ScLine	sclSetdomainname	=
{
    "setdomainname", true, tyArgReg, 0, "PD", tySmashDef, tyScrInt,
    lmsSetdomainname, WhCount(lmsSetdomainname), 0, 0
};



static const ScLine	sclSetfsgid		=
{
    "setfsgid", true, tyArgReg, 0, "D", tySmashNop, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclSetfsuid		=
{
    "setfsuid", true, tyArgReg, 0, "D", tySmashNop, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclSetgid		=
{
    "setgid", true, tyArgReg, 0, "D", tySmashNop, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	lmsSetgroups		[ ] =
{
    { true,  false, tySegListGidT,	tyAddrArg, 1,	tyCountArg, 0	}
};

static const ScLine	sclSetgroups		=
{
    "setgroups", true, tyArgReg, 0, "DP", tySmashMpi0, tyScrInt,
    lmsSetgroups, WhCount(lmsSetgroups), 0, 0
};



static const MsLine	lmsSethostname		[ ] =
{
    { true,  false, tySegStrCount,	tyAddrArg, 0,	tyCountArg, 1	}
};

static const ScLine	sclSethostname		=
{
    "sethostname", true, tyArgReg, 0, "PD", tySmashDef, tyScrInt,
    lmsSethostname, WhCount(lmsSethostname), 0, 0
};



static const MsLine	lmsSetitimer		[ ] =
{
    { true,  false, tySegItimerval,	tyAddrArg, 1,	tyCountOne, 1	},
    { false, true,  tySegItimerval,	tyAddrArg, 2,	tyCountOne, 1	}
};

static const ScLine	sclSetitimer		=
{
    "setitimer", true, tyArgReg, 0, "DPP", tySmashDef, tyScrInt,
    lmsSetitimer, WhCount(lmsSetitimer), 0, 0
};



static const ScLine	sclSetpgid		=
{
    "setpgid", true, tyArgReg, 0, "DD", tySmashPair, tyScrInt,
    0, 0, 0, 0
};




static const ScLine	sclSetpriority		=
{
    "setpriority", true, tyArgReg, 0, "DDD", tySmashDef, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclSetregid		=
{
    "setregid", true, tyArgReg, 0, "DD", tySmashNop, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclSetreuid		=
{
    "setreuid", true, tyArgReg, 0, "DD", tySmashNop, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	lmsSetrlimit		[ ] =
{
    { true,  false, tySegRlimit,	tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclSetrlimit		=
{
    "setrlimit", true, tyArgReg, 0, "DP", tySmashPair, tyScrInt,
    lmsSetrlimit, WhCount(lmsSetrlimit), 0, 0
};



static const ScLine	sclSetsid		=
{
    "setsid", true, tyArgReg, 0, "", tySmashNop, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	lmsSetsockopt		[ ] =
{
    { true,  false, tySegListMmByte,	tyAddrArg, 3,	tyCountArg, 4	}
};

static const ScLine	sclSetsockopt		=
{
    "setsockopt", true, tyArgMem, 1, "DDDPD", tySmashDef, tyScrInt,
    lmsSetsockopt, WhCount(lmsSetsockopt), 0, 0
};



static const MsLine	lmsSettimeofday		[ ] =
{
    { true,  false, tySegTimeval,	tyAddrArg, 0,	tyCountOne, 1	},
    { true,  false, tySegTimezone,	tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclSettimeofday		=
{
    "settimeofday", true, tyArgReg, 0, "PP", tySmashPair, tyScrInt,
    lmsSettimeofday, WhCount(lmsSettimeofday), 0, 0
};



static const ScLine	sclSetuid		=
{
    "setuid", true, tyArgReg, 0, "D", tySmashNop, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclSetup		=
{
    "setup", true, tyArgReg, 0, "", tySmashNop, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclSgetmask		=
{
    "sgetmask", true, tyArgReg, 0, "", tySmashNop, tyScrHex,
    0, 0, 0, 0
};



static const MsLine	lmsShmat		[ ] =
{
    { false, true,  tySegMmAddr,	tyAddrArg, 3,	tyCountOne, 1	}
};

static const ScLine	sclShmat		=
{
    "shmat", true, tyArgReg, 0, "-DOPP", tySmashCant, tyScrInt,
    lmsShmat, WhCount(lmsShmat), 0, 0
};



static const ScLine	sclShmctl		=
{
    "shmctl", true, tyArgReg, 0, "-DD-P", tySmashDef, tyScrInt,
    0, 0, FetchInShmctl, FetchOutShmctl
};



static const ScLine	sclShmdt		=
{
    "shmdt", true, tyArgReg, 0, "----P", tySmashCant, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclShmget		=
{
    "shmget", true, tyArgReg, 0, "-XDO", tySmashDef, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclShutdown		=
{
    "shutdown", true, tyArgMem, 1, "DD", tySmashDef, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	lmsSigaction		[ ] =
{
    { true,  false, tySegSigaction,	tyAddrArg, 1,	tyCountOne, 1	},
    { false, true,  tySegSigaction,	tyAddrArg, 2,	tyCountOne, 1	}
};

static const ScLine	sclSigaction		=
{
    "sigaction", true, tyArgReg, 0, "DPP", tySmashDef, tyScrInt,
    lmsSigaction, WhCount(lmsSigaction), 0, 0
};



static const ScLine	sclSignal		=
{
    "signal", true, tyArgReg, 0, "DP", tySmashDef, tyScrAddr,
    0, 0, 0, 0
};



static const MsLine	lmsSigpending		[ ] =
{
    { false, true,  tySegSigsetT,	tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclSigpending		=
{
    "sigpending", true, tyArgReg, 0, "P", tySmashDef, tyScrInt,
    lmsSigpending, WhCount(lmsSigpending), 0, 0
};



static const MsLine	lmsSigprocmask		[ ] =
{
    { true,  false, tySegSigsetT,	tyAddrArg, 1,	tyCountOne, 1	},
    { false, true,  tySegSigsetT,	tyAddrArg, 2,	tyCountOne, 1	}
};

static const ScLine	sclSigprocmask		=
{
    "sigprocmask", true, tyArgReg, 0, "DPP", tySmashDef, tyScrInt,
    lmsSigprocmask, WhCount(lmsSigprocmask), 0, 0
};



static const ScLine	sclSigreturn		=
{
    "sigreturn", true, tyArgReg, 0, "", tySmashCant, tyScrNot,
    0, 0, FetchInSigreturn, 0
};



static const ScLine	sclSigsuspend		=
{
    "sigsuspend", true, tyArgReg, 0, "DXX", tySmashCant, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclSocket		=
{
    "socket", true, tyArgMem, 1, "DDD", tySmashDef, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	lmsSocketpair		[ ] =
{
    { false, true,  tySegMmWord2,	tyAddrArg, 3,	tyCountOne, 1	}
};

static const ScLine	sclSocketpair		=
{
    "socketpair", true, tyArgMem, 1, "DDDP", tySmashDef, tyScrInt,
    lmsSocketpair, WhCount(lmsSocketpair), 0, 0
};



static const ScLine	sclSsetmask		=
{
    "ssetmask", true, tyArgReg, 0, "X", tySmashNop, tyScrHex,
    0, 0, 0, 0
};



static const MsLine	lmsStat			[ ] =
{
    { true,  false, tySegStrNul,	tyAddrArg, 0,	tyCountOne, 1	},
    { false, true,  tySegNewStat,	tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclStat			=
{
    "stat", true, tyArgReg, 0, "PP", tySmashDef, tyScrInt,
    lmsStat, WhCount(lmsStat), 0, 0
};



static const MsLine	lmsStatfs		[ ] =
{
    { true,  false, tySegStrNul,	tyAddrArg, 0,	tyCountOne, 1	},
    { false, true,  tySegStatfs,	tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclStatfs		=
{
    "statfs", true, tyArgReg, 0, "PP", tySmashDef, tyScrInt,
    lmsStatfs, WhCount(lmsStatfs), 0, 0
};



static const MsLine	lmsStime		[ ] =
{
    { true,  false, tySegTimeT,		tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclStime		=
{
    "stime", true, tyArgReg, 0, "P", tySmashDef, tyScrInt,
    lmsStime, WhCount(lmsStime), 0, 0
};



static const ScLine	sclStty			=
{
    "stty", true, tyArgReg, 0, "", tySmashNop, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	lmsSwapoff		[ ] =
{
    { true,  false, tySegStrNul,	tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclSwapoff		=
{
    "swapoff", true, tyArgReg, 0, "P", tySmashDef, tyScrInt,
    lmsSwapoff, WhCount(lmsSwapoff), 0, 0
};



static const MsLine	lmsSwapon		[ ] =
{
    { true,  false, tySegStrNul,	tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclSwapon		=
{
    "swapon", true, tyArgReg, 0, "PX", tySmashDef, tyScrInt,
    lmsSwapon, WhCount(lmsSwapon), 0, 0
};



static const MsLine	lmsSymlink		[ ] =
{
    { true,  false, tySegStrNul,	tyAddrArg, 0,	tyCountOne, 1	},
    { true,  false, tySegStrNul,	tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclSymlink		=
{
    "symlink", true, tyArgReg, 0, "PP", tySmashDef, tyScrInt,
    lmsSymlink, WhCount(lmsSymlink), 0, 0
};



static const ScLine	sclSync			=
{
    "sync", true, tyArgReg, 0, "", tySmashNop, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclSysfs		=
{
    "sysfs", true, tyArgReg, 0, "DPP", tySmashDef, tyScrInt,
    0, 0, FetchInSysfs, FetchOutSysfs
};



static const MsLine	lmsSysinfo		[ ] =
{
    { false, true,  tySegSysinfo,	tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclSysinfo		=
{
    "sysinfo", true, tyArgReg, 0, "P", tySmashDef, tyScrInt,
    lmsSysinfo, WhCount(lmsSysinfo), 0, 0
};



static const ScLine	sclSyslog		=
{
    "syslog", true, tyArgReg, 0, "DPD", tySmashDef, tyScrInt,
    0, 0, 0, FetchOutSyslog
};



static const MsLine	lmsTime			[ ] =
{
    { false, true,  tySegTimeT,		tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclTime			=
{
    "time", true, tyArgReg, 0, "P", tySmashDef, tyScrInt,
    lmsTime, WhCount(lmsTime), 0, 0
};



static const MsLine	lmsTimes		[ ] =
{
    { false, true,  tySegTms,		tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclTimes		=
{
    "times", true, tyArgReg, 0, "P", tySmashDef, tyScrInt,
    lmsTimes, WhCount(lmsTimes), 0, 0
};



static const MsLine	lmsTruncate		[ ] =
{
    { true,  false, tySegStrNul,	tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclTruncate		=
{
    "truncate", true, tyArgReg, 0, "PD", tySmashDef, tyScrInt,
    lmsTruncate, WhCount(lmsTruncate), 0, 0
};



// Linux 1.3.11: not implemented in kernel.

static const ScLine	sclUlimit		=
{
    "ulimit", true, tyArgReg, 0, "", tySmashDef, tyScrInt,
    0, 0, 0, 0
};



static const ScLine	sclUmask		=
{
    "umask", true, tyArgReg, 0, "O", tySmashNop, tyScrOct,
    0, 0, 0, 0
};



static const MsLine	lmsUmount		[ ] =
{
    { true,  false, tySegStrNul,	tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclUmount		=
{
    "umount", true, tyArgReg, 0, "P", tySmashDef, tyScrInt,
    lmsUmount, WhCount(lmsUmount), 0, 0
};



static const MsLine	lmsUname		[ ] =
{
    { false, true,  tySegNewUtsname,	tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclUname		=
{
    "uname", true, tyArgReg, 0, "P", tySmashDef, tyScrInt,
    lmsUname, WhCount(lmsUname), 0, 0
};



static const MsLine	lmsUnlink		[ ] =
{
    { true,  false, tySegStrNul,	tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclUnlink		=
{
    "unlink", true, tyArgReg, 0, "P", tySmashDef, tyScrInt,
    lmsUnlink, WhCount(lmsUnlink), 0, 0
};



static const MsLine	lmsUselib		[ ] =
{
    { true,  false, tySegStrNul,	tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclUselib		=
{
    "uselib", true, tyArgReg, 0, "P", tySmashFile0, tyScrInt,
    lmsUselib, WhCount(lmsUselib), FetchInUselib, FetchOutUselib
};



static const MsLine	lmsUstat		[ ] =
{
    { false, true,  tySegUstat,		tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclUstat		=
{
    "ustat", true, tyArgReg, 0, "DP", tySmashPair, tyScrInt,
    lmsUstat, WhCount(lmsUstat), 0, 0
};



static const MsLine	lmsUtime		[ ] =
{
    { true,  false, tySegStrNul,	tyAddrArg, 0,	tyCountOne, 1	},
    { true,  false, tySegUtimbuf,	tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclUtime		=
{
    "utime", true, tyArgReg, 0, "PP", tySmashDef, tyScrInt,
    lmsUtime, WhCount(lmsUtime), 0, 0
};



static const ScLine	sclVhangup		=
{
    "vhangup", true, tyArgReg, 0, "", tySmashNop, tyScrInt,
    0, 0, 0, 0
};



static const MsLine	lmsVm86			[ ] =
{
    { true,  true,  tySegVm86Struct,	tyAddrArg, 0,	tyCountOne, 1	}
};

static const ScLine	sclVm86			=
{
    "vm86", true, tyArgReg, 0, "P", tySmashCant, tyScrInt,
    lmsVm86, WhCount(lmsVm86), 0, 0
};



static const MsLine	lmsWait4		[ ] =
{
    { false, true,  tySegMmWord,	tyAddrArg, 1,	tyCountOne, 1	},
    { false, true,  tySegRusage,	tyAddrArg, 3,	tyCountOne, 1	}
};

static const ScLine	sclWait4		=
{
    "wait4", true, tyArgReg, 0, "DPDP", tySmashPair, tyScrInt,
    lmsWait4, WhCount(lmsWait4), 0, 0
};



static const MsLine	lmsWaitpid		[ ] =
{
    { false, true,  tySegMmWord,	tyAddrArg, 1,	tyCountOne, 1	}
};

static const ScLine	sclWaitpid		=
{
    "waitpid", true, tyArgReg, 0, "DPD", tySmashPair, tyScrInt,
    lmsWaitpid, WhCount(lmsWaitpid), 0, 0
};



static const MsLine	lmsWrite		[ ] =
{
    { true,  false, tySegStrCount,	tyAddrArg, 1,	tyCountArg, 2	}
};

static const ScLine	sclWrite		=
{
    "write", true, tyArgReg, 0, "DPD", tySmashReplay, tyScrInt,
    lmsWrite, WhCount(lmsWrite), 0, 0
};



// System call line for unknowns.
static const ScLine	sclUnknown		=
{
    "", false, tyArgReg, 0, "XXXXX", tySmashCant, tyScrInt,
    0, 0, 0, 0
};



// Init a sys call line by system call entry.
void ScLine::initFromSce( MmWord wSysEntry, MmWord wSubEntry )
{
    switch ( wSysEntry )
    {
    default:			*this = sclUnknown;		break;
    case __NR_access:		*this = sclAccess;		break;
    case __NR_acct:		*this = sclAcct;		break;
    case __NR_adjtimex:		*this = sclAdjtimex;		break;
    case __NR_alarm:		*this = sclAlarm;		break;
    case __NR_bdflush:		*this = sclBdflush;		break;
    case __NR_break:		*this = sclBreak;		break;
    case __NR_brk:		*this = sclBrk;			break;
    case __NR_chdir:		*this = sclChdir;		break;
    case __NR_chmod:		*this = sclChmod;		break;
    case __NR_chown:		*this = sclChown;		break;
    case __NR_chroot:		*this = sclChroot;		break;
    case __NR_clone:		*this = sclClone;		break;
    case __NR_close:		*this = sclClose;		break;
    case __NR_creat:		*this = sclCreat;		break;
    case __NR_create_module:	*this = sclCreateModule;	break;
    case __NR_delete_module:	*this = sclDeleteModule;	break;
    case __NR_dup:		*this = sclDup;			break;
    case __NR_dup2:		*this = sclDup2;		break;
    case __NR_execve:		*this = sclExecve;		break;
    case __NR_exit:		*this = sclExit;		break;
    case __NR_fchdir:		*this = sclFchdir;		break;
    case __NR_fchmod:		*this = sclFchmod;		break;
    case __NR_fchown:		*this = sclFchown;		break;
    case __NR_fcntl:		*this = sclFcntl;		break;
    case __NR_fork:		*this = sclFork;		break;
    case __NR_fstat:		*this = sclFstat;		break;
    case __NR_fstatfs:		*this = sclFstatfs;		break;
    case __NR_fsync:		*this = sclFsync;		break;
    case __NR_ftime:		*this = sclFtime;		break;
    case __NR_ftruncate:	*this = sclFtruncate;		break;
    case __NR_get_kernel_syms:	*this = sclGetKernelSyms;	break;
    case __NR_getdents:		*this = sclGetdents;		break;
    case __NR_getegid:		*this = sclGetegid;		break;
    case __NR_geteuid:		*this = sclGeteuid;		break;
    case __NR_getgid:		*this = sclGetgid;		break;
    case __NR_getgroups:	*this = sclGetgroups;		break;
    case __NR_getitimer:	*this = sclGetitimer;		break;
    case __NR_getpgid:		*this = sclGetpgid;		break;
    case __NR_getpgrp:		*this = sclGetpgrp;		break;
    case __NR_getpid:		*this = sclGetpid;		break;
    case __NR_getppid:		*this = sclGetppid;		break;
    case __NR_getpriority:	*this = sclGetpriority;		break;
    case __NR_getrlimit:	*this = sclGetrlimit;		break;
    case __NR_getrusage:	*this = sclGetrusage;		break;
    case __NR_gettimeofday:	*this = sclGettimeofday;	break;
    case __NR_getuid:		*this = sclGetuid;		break;
    case __NR_gtty:		*this = sclGtty;		break;
    case __NR_idle:		*this = sclIdle;		break;
    case __NR_init_module:	*this = sclInitModule;		break;
    case __NR_ioctl:		*this = sclIoctl;		break;
    case __NR_ioperm:		*this = sclIoperm;		break;
    case __NR_iopl:		*this = sclIopl;		break;
    case __NR_ipc:
	switch ( wSubEntry & 0xFFFF )
	{
	default:		*this = sclUnknown;		break;
	case MSGCTL:		*this = sclMsgctl;		break;
	case MSGGET:		*this = sclMsgget;		break;
	case MSGRCV:		break;
	    switch ( wSubEntry >> 16 )
	    {
	    default:		*this = sclUnknown;		break;
	    case 0:		*this = sclMsgrcv0;		break;
	    case 1:		*this = sclMsgrcv1;		break;
	    }
	    break;
	case MSGSND:		*this = sclMsgsnd;		break;
	case SEMCTL:		*this = sclSemctl;		break;
	case SEMGET:		*this = sclSemget;		break;
	case SEMOP:		*this = sclSemop;		break;
	case SHMAT:		*this = sclShmat;		break;
	case SHMCTL:		*this = sclShmctl;		break;
	case SHMDT:		*this = sclShmdt;		break;
	case SHMGET:		*this = sclShmget;		break;
	}
	break;
    case __NR_kill:		*this = sclKill;		break;
    case __NR_link:		*this = sclLink;		break;
    case __NR__llseek:		*this = sclLlseek;		break;
    case __NR_lock:		*this = sclLock;		break;
    case __NR_lseek:		*this = sclLseek;		break;
    case __NR_lstat:		*this = sclLstat;		break;
    case __NR_mkdir:		*this = sclMkdir;		break;
    case __NR_mknod:		*this = sclMknod;		break;
    case __NR_mmap:		*this = sclMmap;		break;
    case __NR_modify_ldt:	*this = sclModifyLdt;		break;
    case __NR_mount:		*this = sclMount;		break;
    case __NR_mprotect:		*this = sclMprotect;		break;
    case __NR_mpx:		*this = sclMpx;			break;
    case __NR_msync:		*this = sclMsync;		break;
    case __NR_munmap:		*this = sclMunmap;		break;
    case __NR_nice:		*this = sclNice;		break;
    case __NR_oldfstat:		*this = sclOldfstat;		break;
    case __NR_oldlstat:		*this = sclOldlstat;		break;
    case __NR_oldolduname:	*this = sclOldolduname;		break;
    case __NR_oldstat:		*this = sclOldstat;		break;
    case __NR_olduname:		*this = sclOlduname;		break;
    case __NR_open:		*this = sclOpen;		break;
    case __NR_pause:		*this = sclPause;		break;
    case __NR_personality:	*this = sclPersonality;		break;
    case __NR_phys:		*this = sclPhys;		break;
    case __NR_pipe:		*this = sclPipe;		break;
    case __NR_prof:		*this = sclProf;		break;
    case __NR_profil:		*this = sclProfil;		break;
    case __NR_ptrace:		*this = sclPtrace;		break;
    case __NR_quotactl:		*this = sclQuotactl;		break;
    case __NR_read:		*this = sclRead;		break;
    case __NR_readdir:		*this = sclReaddir;		break;
    case __NR_readlink:		*this = sclReadlink;		break;
    case __NR_reboot:		*this = sclReboot;		break;
    case __NR_rename:		*this = sclRename;		break;
    case __NR_rmdir:		*this = sclRmdir;		break;
    case __NR_select:		*this = sclSelect;		break;
    case __NR_setdomainname:	*this = sclSetdomainname;	break;
    case __NR_setfsgid:		*this = sclSetfsgid;		break;
    case __NR_setfsuid:		*this = sclSetfsuid;		break;
    case __NR_setgid:		*this = sclSetgid;		break;
    case __NR_setgroups:	*this = sclSetgroups;		break;
    case __NR_sethostname:	*this = sclSethostname;		break;
    case __NR_setitimer:	*this = sclSetitimer;		break;
    case __NR_setpgid:		*this = sclSetpgid;		break;
    case __NR_setpriority:	*this = sclSetpriority;		break;
    case __NR_setregid:		*this = sclSetregid;		break;
    case __NR_setreuid:		*this = sclSetreuid;		break;
    case __NR_setrlimit:	*this = sclSetrlimit;		break;
    case __NR_setsid:		*this = sclSetsid;		break;
    case __NR_settimeofday:	*this = sclSettimeofday;	break;
    case __NR_setuid:		*this = sclSetuid;		break;
    case __NR_setup:		*this = sclSetup;		break;
    case __NR_sgetmask:		*this = sclSgetmask;		break;
    case __NR_sigaction:	*this = sclSigaction;		break;
    case __NR_signal:		*this = sclSignal;		break;
    case __NR_sigpending:	*this = sclSigpending;		break;
    case __NR_sigprocmask:	*this = sclSigprocmask;		break;
    case __NR_sigreturn:	*this = sclSigreturn;		break;
    case __NR_sigsuspend:	*this = sclSigsuspend;		break;
    case __NR_socketcall:
	switch ( wSubEntry )
	{
	default:		*this = sclUnknown;		break;
	case SYS_ACCEPT:	*this = sclAccept;		break;
	case SYS_BIND:		*this = sclBind;		break;
	case SYS_CONNECT:	*this = sclConnect;		break;
	case SYS_GETPEERNAME:	*this = sclGetpeername;		break;
	case SYS_GETSOCKNAME:	*this = sclGetsockname;		break;
	case SYS_GETSOCKOPT:	*this = sclGetsockopt;		break;
	case SYS_LISTEN:	*this = sclListen;		break;
	case SYS_RECV:		*this = sclRecv;		break;
	case SYS_RECVFROM:	*this = sclRecvfrom;		break;
	case SYS_RECVMSG:	*this = sclRecvmsg;		break;
	case SYS_SEND:		*this = sclSend;		break;
	case SYS_SENDMSG:	*this = sclSendmsg;		break;
	case SYS_SENDTO:	*this = sclSendto;		break;
	case SYS_SETSOCKOPT:	*this = sclSetsockopt;		break;
	case SYS_SHUTDOWN:	*this = sclShutdown;		break;
	case SYS_SOCKET:	*this = sclSocket;		break;
	case SYS_SOCKETPAIR:	*this = sclSocketpair;		break;
	}
	break;
    case __NR_ssetmask:		*this = sclSsetmask;		break;
    case __NR_stat:		*this = sclStat;		break;
    case __NR_statfs:		*this = sclStatfs;		break;
    case __NR_stime:		*this = sclStime;		break;
    case __NR_stty:		*this = sclStty;		break;
    case __NR_swapoff:		*this = sclSwapoff;		break;
    case __NR_swapon:		*this = sclSwapon;		break;
    case __NR_symlink:		*this = sclSymlink;		break;
    case __NR_sync:		*this = sclSync;		break;
    case __NR_sysfs:		*this = sclSysfs;		break;
    case __NR_sysinfo:		*this = sclSysinfo;		break;
    case __NR_syslog:		*this = sclSyslog;		break;
    case __NR_time:		*this = sclTime;		break;
    case __NR_times:		*this = sclTimes;		break;
    case __NR_truncate:		*this = sclTruncate;		break;
    case __NR_ulimit:		*this = sclUlimit;		break;
    case __NR_umask:		*this = sclUmask;		break;
    case __NR_umount:		*this = sclUmount;		break;
    case __NR_uname:		*this = sclUname;		break;
    case __NR_unlink:		*this = sclUnlink;		break;
    case __NR_uselib:		*this = sclUselib;		break;
    case __NR_ustat:		*this = sclUstat;		break;
    case __NR_utime:		*this = sclUtime;		break;
    case __NR_vhangup:		*this = sclVhangup;		break;
    case __NR_vm86:		*this = sclVm86;		break;
    case __NR_wait4:		*this = sclWait4;		break;
    case __NR_waitpid:		*this = sclWaitpid;		break;
    case __NR_write:		*this = sclWrite;		break;
    }
}



// Fetch all segments in map (utility).
MmRet FetchAllArea
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    for ( int iAreaFetch = 0; iAreaFetch < mapFetch.count( ); ++iAreaFetch )
    {
	const MmArea & areaFetch = mapFetch.getArea( iAreaFetch );
	switch ( areaFetch.getTyArea( ) )
	{
	default:
	    break;

	case MmArea::tyAreaText:
	case MmArea::tyAreaData:
	case MmArea::tyAreaBss:
	case MmArea::tyAreaBrk:
	case MmArea::tyAreaLib:
	case MmArea::tyAreaMmap:
	case MmArea::tyAreaStack:
	    {
		// Fetch segment.
		MmSeg segFetch;
		MmRetCheck( segFetch.fetchProc( procFetch,
		    areaFetch.getTyArea( ), tySegArea,
		    areaFetch.getAddrMin( ), areaFetch.count( ) ) );

		// Compare against matching input segment.
		bool fMatch = false;
		for ( int isegIn  = 0;
			  isegIn  < evSciArg.getSeg( ).count( );
			  isegIn += 1 )
		{
#if 0
		    if ( segFetch.matchSeg( evSciArg.getSeg( isegIn ) ) )
		    {
			fMatch = true;
			break;
		    }
#endif
		}

		// Append if no match.
		if ( !fMatch )
		    evTarget.appSeg( segFetch );
	    }
	    break;
	}
    }

    return mmRetOk;
}



// Fetch segin's (combiner).
MmRet FetchInExecve
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    // Fetch argument file into a flat.
    if ( evSciArg.getSeg( ).count( ) > 0 )
    {
	const MmSeg & segInName = evSciArg.getSeg( )[0];
	segInName.checkCcs( );
	const char * pstrInName = (const char *) segInName.address( );
	if ( pstrInName[0] == '/'
	    ? procFetch.isFollowRoot( ) : procFetch.isFollowCwd( ) )
	{
	    MmFlat flatIn;
	    {
		WhFile fileIn;
		MmRetCheck( fileIn.openName( WhString( pstrInName ),
		    WhFile::tyOpenRead ) );
		MmRetCheck( flatIn.fromFile( fileIn ) );
		MmRetCheck( fileIn.closeFile( ) );
	    }
	    evTarget.appFlat( flatIn );
	}
    }

    // Count argv pointers.
    const MmAddr argv = MmAddr( evSciArg.getArg( 1 ) );
    int naddrArg = 0;
    if ( argv != 0 )
    {
	for ( ; ; )
	{
	    MmSeg segInAddr;
	    MmRetCheck( segInAddr.fetchProc( procFetch, MmArea::tyAreaData,
		tySegMmAddr, argv + naddrArg * sizeof(MmAddr), 1 ) );
	    ++naddrArg;
	    if ( * (const MmAddr *) segInAddr.address( ) == 0 )
		break;
	}
    }

    // Fetch argv pointers.
    MmSeg segInAddrArg;
    MmRetCheck( segInAddrArg.fetchProc( procFetch, MmArea::tyAreaData,
	tySegListMmAddr, argv, naddrArg ) );
    evTarget.appSeg( segInAddrArg );

    // Fetch argv strings.
    const MmAddr * paddrArg = (const MmAddr *) segInAddrArg.address( );
    for ( int iaddrArg = 0; iaddrArg < naddrArg - 1; ++iaddrArg )
    {
	MmSeg segInArg;
	MmRetCheck( segInArg.fetchProc( procFetch, MmArea::tyAreaData,
	    tySegStrNulArg, paddrArg[iaddrArg], 1 ) );
	evTarget.appSeg( segInArg );
    }

    // Count envp pointers.
    const MmAddr envp = MmAddr( evSciArg.getArg( 2 ) );
    int naddrEnv = 0;
    if ( envp != 0 )
    {
	for ( ; ; )
	{
	    MmSeg segInAddr;
	    MmRetCheck( segInAddr.fetchProc( procFetch, MmArea::tyAreaData,
		tySegMmAddr, envp + naddrEnv * sizeof(MmAddr), 1 ) );
	    ++naddrEnv;
	    if ( * (const MmAddr *) segInAddr.address( ) == 0 )
		break;
	}
    }

    // Fetch envp pointers.
    MmSeg segInAddrEnv;
    MmRetCheck( segInAddrEnv.fetchProc( procFetch, MmArea::tyAreaData,
	tySegListMmAddr, envp, naddrEnv ) );
    evTarget.appSeg( segInAddrEnv );

    // Fetch envp strings.
    const MmAddr * paddrEnv = (const MmAddr *) segInAddrEnv.address( );
    for ( int iaddrEnv = 0; iaddrEnv < naddrEnv - 1; ++iaddrEnv )
    {
	MmSeg segInEnv;
	MmRetCheck( segInEnv.fetchProc( procFetch, MmArea::tyAreaData,
	    tySegStrNulEnv, paddrEnv[iaddrEnv], 1 ) );
	evTarget.appSeg( segInEnv );
    }

    // That's all, folks.
    return mmRetOk;
}



// Fetch segin's (combiner).
MmRet FetchInFcntl
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    switch ( evSciArg.getArg( 1 ) )
    {
    default:
	break;

    case F_DUPFD:
    case F_GETFD:
    case F_GETFL:
    case F_GETOWN:
    case F_SETFD:
    case F_SETFL:
    case F_SETOWN:
	break;

    case F_GETLK:
    case F_SETLK:
    case F_SETLKW:
	{
	    MmSeg segInFlock;
	    MmRetCheck( segInFlock.fetchProc( procFetch, MmArea::tyAreaData,
		tySegFlock, MmAddr( evSciArg.getArg( 2 ) ), 1 ) );
	    evTarget.appSeg( segInFlock );
	}
	break;
    }

    return mmRetOk;
}



// Fetch segin's (combiner).
MmRet FetchInInitModule
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    // Linux 1.3.6: kernel has special address check.
    const MmAddr addrSymtab = MmAddr( evSciArg.getArg( 4 ) );
    if ( addrSymtab != 0 && addrSymtab <= MmAddr( 0xB0000000 ) )
    {
	MmSeg segInLen;
	MmRetCheck( segInLen.fetchProc( procFetch, MmArea::tyAreaData,
	    tySegMmWord, addrSymtab, 1 ) );
	const MmWord sSymtab = * (const MmWord *) segInLen.address( );
	if ( int( sSymtab ) > 0 )
	{
	    MmSeg segInSymbolTable;
	    MmRetCheck( segInSymbolTable.fetchProc( procFetch,
		MmArea::tyAreaData, tySegSymbolTable, addrSymtab, sSymtab ) );
	    evTarget.appSeg( segInSymbolTable );
	}
	else
	{
	    evTarget.appSeg( segInLen );
	}
    }

    return mmRetOk;
}



// Fetch segin's (combiner).
MmRet FetchInIoctl
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    // Get values from ingoing.
    const MmWord wRequest = evSciArg.getArg( 1 );
    const MmAddr addrIn   = MmAddr( evSciArg.getArg( 2 ) );

    if ( wRequest == TIOCLINUX )
    {
	// Fetch the distinguishing byte.
	//   Linux 1.3.24: see 'tty_ioctl' in 'drivers/char/tty_io.c'.
	MmSeg segInRequestSub;
	MmRetCheck( segInRequestSub.fetchProc( procFetch, MmArea::tyAreaData,
	    tySegMmByte, addrIn, 1 ) );
	evTarget.appSeg( segInRequestSub );

	// Get matching RI lines.
	WhList <const RiLine *> lpri;
	if ( segInRequestSub.isBound( ) )
	{
	    const MmByte bRequestSub =
		* (const MmByte *) segInRequestSub.address( );
	    RiLineGetTlx( bRequestSub, lpri );
	}

	// Fetch all matching segments.
	for ( int ipri = 0; ipri < lpri.count( ); ++ipri )
	{
	    // Grab the RI line.
	    const RiLine * pri = lpri[ipri];
	    if ( pri == 0 )
		WhAbort( "FetchInIoctl: zero pointer." );

	    if ( pri->itySegIn != tySegNil )
	    {
		// Fetch the segment.
		MmSeg segIn;
		MmRetCheck( segIn.fetchProc( procFetch, MmArea::tyAreaData,
		    pri->itySegIn, addrIn, 1 ) );
		evTarget.appSeg( segIn );
	    }
	}
    }
    else if ( wRequest >= SIOCDEVPRIVATE && wRequest <= SIOCDEVPRIVATE+15 )
    {
	MmRetCheck( FetchAllArea(
	    procFetch, mapFetch, evSciArg, evScoScr, evTarget ) );
    }
    else if ( wRequest >= SIOCPROTOPRIVATE && wRequest <= SIOCPROTOPRIVATE+15 )
    {
	MmRetCheck( FetchAllArea(
	    procFetch, mapFetch, evSciArg, evScoScr, evTarget ) );
    }
    else
    {
	// Get matching RI lines.
	WhList <const RiLine *> lpri;
	RiLineGet( wRequest, lpri );

	// Fetch all matching segments.
	for ( int ipri = 0; ipri < lpri.count( ); ++ipri )
	{
	    // Grab the RI line.
	    const RiLine * pri = lpri[ipri];
	    if ( pri == 0 )
		WhAbort( "FetchInIoctl: zero pointer." );

	    if ( addrIn != 0 && pri->itySegIn != tySegNil )
	    {
		// Fetch the segment.
		MmSeg segIn;
		MmRetCheck( segIn.fetchProc( procFetch, MmArea::tyAreaData,
		    pri->itySegIn, addrIn, 1 ) );
		evTarget.appSeg( segIn );
	    }
	}

	// Fetch any special segment.
	switch ( wRequest )
	{
	default:
	    break;

#if 0
	case EQL_ENSLAVE:
	case EQL_EMANCIPATE:
	    {
		MmSeg segInSlavingRequest;
		const MmSeg * psegInIfreq = evSciArg.getSegMatch(
		    addrIn, sizeof(struct ifreq) );
		if ( psegInIfreq != 0 && psegInIfreq->isBound( ) )
		{
		    const struct ifreq & ifreq =
			* (const struct ifreq *)
			( psegInIfreq->address( )
			+ ( addrIn - psegInIfreq->getAddrFirst( ) ) );
		    MmRetCheck( segInSlavingRequest.fetchProc( procFetch,
			MmArea::tyAreaData, tySegSlavingRequest,
			MmAddr( ifreq.ifr_data ), 1 ) );
		}
		evTarget.appSeg( segInSlavingRequest );
	    }
	    break;

	case EQL_GETSLAVECFG:
	case EQL_SETSLAVECFG:
	    {
		MmSeg segInSlaveConfig;
		const MmSeg * psegInIfreq = evSciArg.getSegMatch(
		    addrIn, sizeof(struct ifreq) );
		if ( psegInIfreq != 0 && psegInIfreq->isBound( ) )
		{
		    const struct ifreq & ifreq =
			* (const struct ifreq *)
			( psegInIfreq->address( )
			+ ( addrIn - psegInIfreq->getAddrFirst( ) ) );
		    MmRetCheck( segInSlaveConfig.fetchProc( procFetch,
			MmArea::tyAreaData, tySegSlaveConfig,
			MmAddr( ifreq.ifr_data ), 1 ) );
		}
		evTarget.appSeg( segInSlaveConfig );
	    }
	    break;

	case EQL_SETMASTRCFG:
	    {
		MmSeg segInMasterConfig;
		const MmSeg * psegInIfreq = evSciArg.getSegMatch(
		    addrIn, sizeof(struct ifreq) );
		if ( psegInIfreq != 0 && psegInIfreq->isBound( ) )
		{
		    const struct ifreq & ifreq =
			* (const struct ifreq *)
			( psegInIfreq->address( )
			+ ( addrIn - psegInIfreq->getAddrFirst( ) ) );
		    MmRetCheck( segInMasterConfig.fetchProc( procFetch,
			MmArea::tyAreaData, tySegMasterConfig,
			MmAddr( ifreq.ifr_data ), 1 ) );
		}
		evTarget.appSeg( segInMasterConfig );
	    }
	    break;
#endif

	case FDRAWCMD:
	    {
		MmSeg segInData;
		const MmSeg * psegInFloppyRawCmd = evSciArg.getSegMatch(
		    addrIn, sizeof(struct floppy_raw_cmd) );
		if ( psegInFloppyRawCmd != 0 && psegInFloppyRawCmd->isBound( ) )
		{
		    const struct floppy_raw_cmd & floppy_raw_cmd =
			* (const struct floppy_raw_cmd *)
			( psegInFloppyRawCmd->address( )
			+ ( addrIn - psegInFloppyRawCmd->getAddrFirst( ) ) );
		    if ( ( floppy_raw_cmd.flags & FD_RAW_WRITE ) != 0
		    &&   floppy_raw_cmd.length >= 0 )
		    {
			MmRetCheck( segInData.fetchProc( procFetch,
			    MmArea::tyAreaData, tySegListMmByte,
			    MmAddr( floppy_raw_cmd.data ),
			    floppy_raw_cmd.length ) );
		    }
		}
		evTarget.appSeg( segInData );
	    }
	    break;

	case PIO_FONTX:
	    {
		MmSeg segInData;
		const MmSeg * psegInConsolefontdesc = evSciArg.getSegMatch(
		    addrIn, sizeof(struct consolefontdesc) );
		if ( psegInConsolefontdesc != 0
		&&   psegInConsolefontdesc->isBound( ) )
		{
		    const struct consolefontdesc & consolefontdesc =
			* (const struct consolefontdesc *)
			( psegInConsolefontdesc->address( )
			+ ( addrIn - psegInConsolefontdesc->getAddrFirst( ) )
			);
		    const int nChar = consolefontdesc.charcount;
		    if ( nChar >= 0 )
		    {
			MmRetCheck( segInData.fetchProc( procFetch,
			    MmArea::tyAreaData, tySegAny,
			    MmAddr( consolefontdesc.chardata ),
			    nChar * sizeof(MmByte) ) );
		    }
		}
		evTarget.appSeg( segInData );
	    }
	    break;

	case PIO_UNIMAP:
	    {
		MmSeg segInListUnipair;
		const MmSeg * psegInUnimapdesc = evSciArg.getSegMatch(
		    addrIn, sizeof(struct unimapdesc) );
		if ( psegInUnimapdesc != 0 && psegInUnimapdesc->isBound( ) )
		{
		    const struct unimapdesc & unimapdesc =
			* (const struct unimapdesc *)
			( psegInUnimapdesc->address( ) -
			+ ( addrIn - psegInUnimapdesc->getAddrFirst( ) ) );
		    const int nEntry = unimapdesc.entry_ct;
		    if ( nEntry >= 0 )
		    {
			MmRetCheck( segInListUnipair.fetchProc( procFetch,
			    MmArea::tyAreaData, tySegListUnipair,
			    MmAddr( unimapdesc.entries ), nEntry ) );
		    }
		}
		evTarget.appSeg( segInListUnipair );
	    }
	    break;

	case SIOCADDRT:
	case SIOCDELRT:
	    // Linux 1.3.24: args are variable and some are deep.
	    {
#if 1
		MmRetCheck( FetchAllArea(
		    procFetch, mapFetch, evSciArg, evScoScr, evTarget ) );
#else
		MmSeg segInName;
		const MmSeg * psegInRtentry = evSciArg.getSegMatch(
		    addrIn, sizeof(struct rtentry) );
		if ( psegInRtentry != 0 && psegInRtentry->isBound( ) )
		{
		    const struct rtentry & rtentry =
			* (const struct rtentry *)
			( psegInRtentry->address( )
			+ ( addrIn - psegInRtentry->getAddrFirst( ) ) );
		    MmRetCheck( segInName.fetchProc( procFetch, MmArea::tyAreaData,
			tySegStrNul, MmAddr( rtentry.rt_dev ), 1 ) );
		}
		evTarget.appSeg( segInName );
#endif
	    }
	    break;
	}
    }

    // That's all, folks.
    return mmRetOk;
}



// Fetch segin's (combiner).
MmRet FetchInModifyLdt
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    switch ( evSciArg.getArg( 0 ) )
    {
    default:
	break;

    case 0:
	break;

    case 1:
	if ( int( evSciArg.getArg( 2 ) ) >= 0 )
	{
	    MmSeg segInModifyLdtLdtS;
	    MmRetCheck( segInModifyLdtLdtS.fetchProc( procFetch,
		MmArea::tyAreaData, tySegModifyLdtLdtS,
		MmAddr( evSciArg.getArg( 1 ) ),
		int( evSciArg.getArg( 2 ) ) ) );
	    evTarget.appSeg( segInModifyLdtLdtS );
	}
	break;
    }

    return mmRetOk;
}



// Fetch segin's (combiner).
MmRet FetchInMount
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    MmSeg segInData;
#if 0
    // I don't know what size to make this.
    MmRetCheck( segInData.fetchProc( procFetch, MmArea::tyAreaData,
	tySegAny, MmAddr( evSciArg.getArg( 4 ) ), ... ) );
#endif
    evTarget.appSeg( segInData );
    return mmRetOk;
}



// Fetch segin's (combiner).
MmRet FetchInMsgctl
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    switch ( evSciArg.getArg( 0 ) )
    {
    default:
	break;

    case IPC_INFO:
    case IPC_RMID:
    case IPC_STAT:
    case MSG_INFO:
    case MSG_STAT:
	break;

    case IPC_SET:
	{
	    MmSeg segInMsqidDs;
	    MmRetCheck( segInMsqidDs.fetchProc( procFetch, MmArea::tyAreaData,
		tySegMsqidDs, MmAddr( evSciArg.getArg( 4 ) ), 1 ) );
	    evTarget.appSeg( segInMsqidDs );
	}
	break;
    }

    return mmRetOk;
}



// Fetch segin's (combiner).
MmRet FetchInMsgsnd
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    const int sText = int( evSciArg.getArg( 2 ) );
    if ( sText >= 0 )
    {
	struct msgbuf msgbufForSize;
	MmSeg segInMsgbuf;
	MmRetCheck( segInMsgbuf.fetchProc( procFetch, MmArea::tyAreaData,
	    tySegMsgbuf,
	    MmAddr( evSciArg.getArg( 4 ) ),
	    MmAddr( &msgbufForSize.mtext[sText] ) - MmAddr( &msgbufForSize )
	    ) );
	evTarget.appSeg( segInMsgbuf );
    }
    return mmRetOk;
}



// Fetch segin's (combiner).
MmRet FetchInNewselect
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    return FetchInSelect( procFetch, mapFetch, evSciArg, evScoScr, evTarget );
}



// Fetch segin's (combiner).
MmRet FetchInRecvmsg
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    // Grab the msghdr.
    const MmAddr addrMsghdr = MmAddr( evSciArg.getArg( 1 ) );
    const MmSeg * psegInMsghdr = evSciArg.getSegMatch(
	addrMsghdr, sizeof(struct msghdr) );

    // Fetch segments.
    if ( psegInMsghdr != 0 && psegInMsghdr->isBound( ) )
    {
	const struct msghdr msghdr =
	    * (const struct msghdr *)
	    ( psegInMsghdr->address( )
	    + ( addrMsghdr - psegInMsghdr->getAddrFirst( ) ) );

	// Fetch socket name.
	MmSeg segInName;
	if ( MmAddr( msghdr.msg_name ) != 0 && msghdr.msg_namelen >= 0 )
	{
	    MmRetCheck( segInName.fetchProc( procFetch,
		MmArea::tyAreaData, tySegListMmByte,
		MmAddr( msghdr.msg_name ), msghdr.msg_namelen ) );
	}
	evTarget.appSeg( segInName );

	// Fetch iovec list.
	MmSeg segInListIovec;
	if ( msghdr.msg_iovlen >= 0 )
	{
	    MmRetCheck( segInListIovec.fetchProc( procFetch,
		MmArea::tyAreaData, tySegListIovec,
		MmAddr( msghdr.msg_iov ), msghdr.msg_iovlen ) );
	}
	evTarget.appSeg( segInListIovec );

	// Fetch accrights.
	MmSeg segInAccrights;
	if ( MmAddr( msghdr.msg_accrights ) != 0
	&&   msghdr.msg_accrightslen >= 0 )
	{
	    MmRetCheck( segInAccrights.fetchProc( procFetch,
		MmArea::tyAreaData, tySegAny,
		MmAddr( msghdr.msg_accrights ), msghdr.msg_accrightslen ) );
	}
	evTarget.appSeg( segInAccrights );
    }

    // That's all, folks.
    return mmRetOk;
}



// Fetch segin's (combiner).
MmRet FetchInSelect
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    const int fd     = evSciArg.getArg( 0 );
    const int sFdset = fd > 0
			 ? ( (fd - 1) / __NFDBITS + 1 ) * sizeof(MmWord)
			 : sizeof(fd_set);

    if ( MmAddr( evSciArg.getArg( 1 ) ) != 0 )
    {
	MmSeg segInFdsetRead;
	MmRetCheck( segInFdsetRead.fetchProc( procFetch, MmArea::tyAreaData,
	    tySegAny, MmAddr( evSciArg.getArg( 1 ) ), sFdset ) );
	evTarget.appSeg( segInFdsetRead );
    }

    if ( MmAddr( evSciArg.getArg( 2 ) ) != 0 )
    {
	MmSeg segInFdsetWrite;
	MmRetCheck( segInFdsetWrite.fetchProc( procFetch, MmArea::tyAreaData,
	    tySegAny, MmAddr( evSciArg.getArg( 2 ) ), sFdset ) );
	evTarget.appSeg( segInFdsetWrite );
    }

    if ( MmAddr( evSciArg.getArg( 3 ) ) != 0 )
    {
	MmSeg segInFdsetExcept;
	MmRetCheck( segInFdsetExcept.fetchProc( procFetch, MmArea::tyAreaData,
	    tySegAny, MmAddr( evSciArg.getArg( 3 ) ), sFdset ) );
	evTarget.appSeg( segInFdsetExcept );
    }

    if ( MmAddr( evSciArg.getArg( 4 ) ) != 0 )
    {
	MmSeg segInTimeval;
	MmRetCheck( segInTimeval.fetchProc( procFetch, MmArea::tyAreaData,
	    tySegTimeval, MmAddr( evSciArg.getArg( 4 ) ), 1 ) );
	evTarget.appSeg( segInTimeval );
    }

    return mmRetOk;
}



// Fetch segin's (combiner).
MmRet FetchInSemctl
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    switch ( evSciArg.getArg( 3 ) )
    {
    default:
	break;

    case GETALL:
    case GETNCNT:
    case GETPID:
    case GETVAL:
    case GETZCNT:
    case IPC_RMID:
    case IPC_INFO:
    case IPC_STAT:
    case SEM_INFO:
    case SEM_STAT:
    case SETVAL:
	break;

    case IPC_SET:
	{
	    MmSeg segInSemun;
	    MmRetCheck( segInSemun.fetchProc( procFetch, MmArea::tyAreaData,
		tySegSemun, MmAddr( evSciArg.getArg( 4 ) ), 1 ) );
	    const union semun & semun =
		* (const union semun *) segInSemun.address( );

	    MmSeg segInSemidDs;
	    MmRetCheck( segInSemidDs.fetchProc( procFetch, MmArea::tyAreaData,
		tySegSemidDs, MmAddr( semun.buf ), 1 ) );
	    evTarget.appSeg( segInSemidDs );
	}
	break;

    case SETALL:
	{
	    MmSeg segInSemun;
	    MmRetCheck( segInSemun.fetchProc( procFetch, MmArea::tyAreaData,
		tySegSemun, MmAddr( evSciArg.getArg( 4 ) ), 1 ) );
	    const union semun & semun =
		* (const union semun *) segInSemun.address( );

	    MmSeg segInListMmShort;
	    MmRetCheck( segInListMmShort.fetchProc( procFetch,
		MmArea::tyAreaData, tySegListMmShort,
		MmAddr( semun.array ), SEMMSL ) );
	    evTarget.appSeg( segInListMmShort );
	}
	break;
    }

    return mmRetOk;
}



// Fetch segin's (combiner).
MmRet FetchInSendmsg
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    // Grab the msghdr.
    const MmAddr addrMsghdr = MmAddr( evSciArg.getArg( 1 ) );
    const MmSeg * psegInMsghdr = evSciArg.getSegMatch(
	addrMsghdr, sizeof(struct msghdr) );

    // Fetch segments.
    if ( psegInMsghdr != 0 && psegInMsghdr->isBound( ) )
    {
	const struct msghdr msghdr =
	    * (const struct msghdr *)
	    ( psegInMsghdr->address( )
	    + ( addrMsghdr - psegInMsghdr->getAddrFirst( ) ) );

	// Fetch socket name.
	MmSeg segInName;
	if ( MmAddr( msghdr.msg_name ) != 0 && msghdr.msg_namelen >= 0 )
	{
	    MmRetCheck( segInName.fetchProc( procFetch,
		MmArea::tyAreaData, tySegListMmByte,
		MmAddr( msghdr.msg_name ), msghdr.msg_namelen ) );
	}
	evTarget.appSeg( segInName );

	// Fetch iovec list.
	MmSeg segInListIovec;
	if ( msghdr.msg_iovlen >= 0 )
	{
	    MmRetCheck( segInListIovec.fetchProc( procFetch,
		MmArea::tyAreaData, tySegListIovec,
		MmAddr( msghdr.msg_iov ), msghdr.msg_iovlen ) );
	}
	evTarget.appSeg( segInListIovec );

	// Fetch accrights.
	MmSeg segInAccrights;
	if ( MmAddr( msghdr.msg_accrights ) != 0
	&&   msghdr.msg_accrightslen >= 0 )
	{
	    MmRetCheck( segInAccrights.fetchProc( procFetch,
		MmArea::tyAreaData, tySegAny,
		MmAddr( msghdr.msg_accrights ), msghdr.msg_accrightslen ) );
	}
	evTarget.appSeg( segInAccrights );

	// Fetch data.
	if ( segInListIovec.isBound( ) )
	{
	    const struct iovec * plIovec =
		(const struct iovec *) segInListIovec.address( );
	    for ( int iIovec = 0; iIovec < msghdr.msg_iovlen; ++iIovec )
	    {
		MmSeg segInData;
		MmRetCheck( segInData.fetchProc( procFetch,
		    MmArea::tyAreaData, tySegAny,
		    MmAddr( plIovec[iIovec].iov_base ),
		    plIovec[iIovec].iov_len ) );
		evTarget.appSeg( segInData );
	    }
	}
    }

    // That's all, folks.
    return mmRetOk;
}



// Fetch segin's (combiner).
MmRet FetchInShmctl
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    switch ( evSciArg.getArg( 2 ) )
    {
    default:
	break;

    case IPC_INFO:
    case IPC_RMID:
    case IPC_STAT:
    case SHM_INFO:
    case SHM_LOCK:
    case SHM_STAT:
    case SHM_UNLOCK:
	break;

    case IPC_SET:
	{
	    MmSeg segInShmidDs;
	    MmRetCheck( segInShmidDs.fetchProc( procFetch, MmArea::tyAreaData,
		tySegShmidDs, MmAddr( evSciArg.getArg( 4 ) ), 1 ) );
	    evTarget.appSeg( segInShmidDs );
	}
	break;
    }

    return mmRetOk;
}



// Fetch segin's (combiner).
MmRet FetchInSigreturn
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    MmWord wSp;
    if ( !procFetch.fetchRegSp( wSp ) )
	WhAbort( "FetchInSigreturn: failed fetch." );
    MmSeg segInSigcontextStruct;
    MmRetCheck( segInSigcontextStruct.fetchProc( procFetch, MmArea::tyAreaData,
	tySegSigcontextStruct, MmAddr( wSp ), 1 ) );
    evTarget.appSeg( segInSigcontextStruct );
    return mmRetOk;
}



// Fetch segin's (combiner).
MmRet FetchInSysfs
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    switch ( evSciArg.getArg( 0 ) )
    {
    default:
	break;

    case 1:
	{
	    MmSeg segInName;
	    MmRetCheck( segInName.fetchProc( procFetch, MmArea::tyAreaData,
		tySegStrNul, MmAddr( evSciArg.getArg( 1 ) ), 1 ) );
	    evTarget.appSeg( segInName );
	}
	break;

    case 2:
    case 3:
	break;
    }

    return mmRetOk;
}



// Fetch segin's (combiner).
MmRet FetchInUselib
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    // Fetch argument file into a flat.
    if ( evSciArg.getSeg( ).count( ) > 0 )
    {
	const MmSeg & segInName = evSciArg.getSeg( )[0];
	segInName.checkCcs( );
	const char * pstrInName = (const char *) segInName.address( );
	if ( pstrInName[0] == '/'
	    ? procFetch.isFollowRoot( ) : procFetch.isFollowCwd( ) )
	{
	    MmFlat flatIn;
	    {
		WhFile fileIn;
		MmRetCheck( fileIn.openName( WhString( pstrInName ),
		    WhFile::tyOpenRead ) );
		MmRetCheck( flatIn.fromFile( fileIn ) );
		MmRetCheck( fileIn.closeFile( ) );
	    }
	    evTarget.appFlat( flatIn );
	}
    }

    return mmRetOk;
}



// Fetch segout's (combiner).
MmRet FetchOutBdflush
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    MmSeg segOutWord;
    if ( evSciArg.getArg( 0 ) >= 2 && ( evSciArg.getArg( 0 ) & 1 ) == 0 )
    {
	MmRetCheck( segOutWord.fetchProc( procFetch, MmArea::tyAreaData,
	    tySegMmWord, MmAddr( evSciArg.getArg( 1 ) ), 1 ) );
    }
    evTarget.appSeg( segOutWord );
    return mmRetOk;
}



// Fetch segout's (combiner).
MmRet FetchOutBrk
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    if ( !evScoScr.isScrError( ) )
    {
	MmSeg segOutData;
	const MmAddr addrBrkOld = mapFetch.getAddrBrk( );
	const MmAddr addrBrkNew = MmAddr( evScoScr.getScrWord( 0 ) );
	if ( addrBrkNew > addrBrkOld )
	{
	    MmRetCheck( segOutData.fetchProc( procFetch, MmArea::tyAreaBrk,
		tySegBrk, addrBrkOld, addrBrkNew - addrBrkOld ) );
	    segOutData.setAreaNew( true );
	}
	evTarget.appSeg( segOutData );
    }
    return mmRetOk;
}



// Fetch segout's (combiner).
MmRet FetchOutExecve
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    // Translate input flat to new segments.
    if ( !evScoScr.isScrError( ) )
    {
	if ( evSciArg.getFlat( ).count( ) == 0 )
	{
	    evTarget.setUnknown( true );
	}
	else
	{
	    WhList <MmSeg> lsegExe;
	    MmRetCheck( ExeExeToSeg( evSciArg.getFlat( )[0], lsegExe ) );
	    for ( int isegExe = 0; isegExe < lsegExe.count( ); ++isegExe )
		evTarget.appSeg( lsegExe[isegExe] );
	}

	// Fetch the initial stack (replay injects changes).
	MmWord wSp;
	if ( !procFetch.fetchRegSp( wSp ) )
	    WhAbort( "FetchOutExecve: failed fetch." );
	const MmAddr addrSp    = MmAddr( wSp );
	const MmAddr addrSpMax = mapFetch.getAddrSpMax( );
	if ( addrSp > addrSpMax )
	    WhAbort( "FetchOutExecve: bad stack." );

	MmSeg segOutStack;
	MmRetCheck( segOutStack.fetchProc( procFetch, MmArea::tyAreaStack,
	    tySegAny, addrSp, addrSpMax - addrSp ) );
	segOutStack.setAreaNew( true );
	evTarget.appSeg( segOutStack );
    }
    else
    {
	// Fetch name (replay smashes it).
	MmSeg segOutName;
	MmRetCheck( segOutName.fetchProc( procFetch, MmArea::tyAreaData,
	    tySegStrNul, MmAddr( evSciArg.getArg( 0 ) ), 1 ) );
	evTarget.appSeg( segOutName );
    }

    // That's all, folks.
    return mmRetOk;
}



// Fetch segout's (combiner).
MmRet FetchOutFcntl
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    switch ( evSciArg.getArg( 1 ) )
    {
    default:
	evTarget.setUnknown( true );
	break;

    case F_DUPFD:
    case F_GETFD:
    case F_GETFL:
    case F_GETOWN:
    case F_SETFD:
    case F_SETFL:
    case F_SETLK:
    case F_SETLKW:
    case F_SETOWN:
	break;

    case F_GETLK:
	{
	    MmSeg segOutFlock;
	    MmRetCheck( segOutFlock.fetchProc( procFetch, MmArea::tyAreaData,
		tySegFlock, MmAddr( evSciArg.getArg( 2 ) ), 1 ) );
	    evTarget.appSeg( segOutFlock );
	}
	break;
    }

    return mmRetOk;
}



// Fetch segout's (combiner).
MmRet FetchOutIoctl
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    // Get values from ingoing.
    const MmWord wRequest = evSciArg.getArg( 1 );
    const MmAddr addrIn   = MmAddr( evSciArg.getArg( 2 ) );

    if ( wRequest == TIOCLINUX )
    {
	// Get sub-request byte.
	const MmSeg * psegIn = evSciArg.getSegMatch( addrIn, sizeof(MmByte) );
	if ( psegIn != 0 && psegIn->isBound( ) )
	{
	    const MmByte bRequestSub =
		* (const MmByte *)
		( psegIn->address( )
		+ ( addrIn - psegIn->getAddrFirst( ) ) );

	    // Get matching RI lines.
	    WhList <const RiLine *> lpri;
	    RiLineGetTlx( bRequestSub, lpri );

	    if ( lpri.count( ) == 0 )
		evTarget.setUnknown( true );

	    // Fetch all matching segments.
	    for ( int ipri = 0; ipri < lpri.count( ); ++ipri )
	    {
		// Get the RI line.
		const RiLine * pri = lpri[ipri];
		if ( pri == 0 )
		    WhAbort( "FetchOutIoctl: zero pointer." );

		if ( pri->itySegOut != tySegNil )
		{
		    // Fetch the segment.
		    MmSeg segOut;
		    MmRetCheck( segOut.fetchProc( procFetch,
			MmArea::tyAreaData, pri->itySegOut, addrIn, 1 ) );
		    evTarget.appSeg( segOut );
		}
	    }
	}
    }
    else if ( wRequest >= SIOCDEVPRIVATE && wRequest <= SIOCDEVPRIVATE+15 )
    {
	MmRetCheck( FetchAllArea(
	    procFetch, mapFetch, evSciArg, evScoScr, evTarget ) );
    }
    else if ( wRequest >= SIOCPROTOPRIVATE && wRequest <= SIOCPROTOPRIVATE+15 )
    {
	MmRetCheck( FetchAllArea(
	    procFetch, mapFetch, evSciArg, evScoScr, evTarget ) );
    }
    else
    {
	// Get matching RI lines.
	WhList <const RiLine *> lpri;
	RiLineGet( wRequest, lpri );

	// Mark unknown ioctls as unstoreable.
	if ( lpri.count( ) == 0 )
	    evTarget.setUnknown( true );

	// Fetch all matching segments.
	for ( int ipri = 0; ipri < lpri.count( ); ++ipri )
	{
	    // Get the RI line.
	    const RiLine * pri = lpri[ipri];
	    if ( pri == 0 )
		WhAbort( "FetchOutIoctl: zero pointer." );

	    if ( addrIn != 0 && pri->itySegOut != tySegNil )
	    {
		// Fetch the segment.
		MmSeg segOut;
		MmRetCheck( segOut.fetchProc( procFetch, MmArea::tyAreaData,
		    pri->itySegOut, addrIn, 1 ) );
		evTarget.appSeg( segOut );
	    }
	}

	// Fetch any special segment.
	switch ( wRequest )
	{
	default:
	    break;

	case CDROMREADAUDIO:
	    {
		MmSeg segOutListCdromFrame;
		const MmSeg * psegInCdromReadAudio = evSciArg.getSegMatch(
		    addrIn, sizeof(struct cdrom_read_audio) );
		if ( psegInCdromReadAudio != 0
		&&   psegInCdromReadAudio->isBound( ) )
		{
		    const struct cdrom_read_audio & cdrom_read_audio =
			* (const struct cdrom_read_audio *)
			( psegInCdromReadAudio->address( )
			+ ( addrIn - psegInCdromReadAudio->getAddrFirst( ) ) );
		    if ( cdrom_read_audio.nframes >= 0 )
		    {
			MmRetCheck( segOutListCdromFrame.fetchProc( procFetch,
			    MmArea::tyAreaData, tySegListCdromFrame,
			    MmAddr( cdrom_read_audio.buf ),
			    cdrom_read_audio.nframes ) );
		    }
		}
		evTarget.appSeg( segOutListCdromFrame );
	    }
	    break;

	case CDROMREADCOOKED:
	    {
		MmSeg segOutData;
		MmRetCheck( segOutData.fetchProc( procFetch,
		    MmArea::tyAreaData, tySegAny,
		    addrIn, CD_FRAMESIZE ) );
		evTarget.appSeg( segOutData );
	    }
	    break;

	case CDROMREADMODE1:
	    {
		// Linux 1.3.24: size can vary by CD driver.
		const int OPT_BLOCKSIZE = 2048;
		const int sData = OPT_BLOCKSIZE > CD_FRAMESIZE
				    ? OPT_BLOCKSIZE : CD_FRAMESIZE;

		MmSeg segOutData;
		MmRetCheck( segOutData.fetchProc( procFetch,
		    MmArea::tyAreaData, tySegAny, addrIn, sData ) );
		evTarget.appSeg( segOutData );
	    }
	    break;

	case CDROMREADMODE2:
	    {
		MmSeg segOutData;
		MmRetCheck( segOutData.fetchProc( procFetch,
		    MmArea::tyAreaData, tySegAny,
		    addrIn, CD_FRAMESIZE_RAW0 ) );
		evTarget.appSeg( segOutData );
	    }
	    break;

	case CDROMREADRAW:
	    {
		MmSeg segOutData;
		MmRetCheck( segOutData.fetchProc( procFetch,
		    MmArea::tyAreaData, tySegAny,
		    addrIn, CD_FRAMESIZE_RAW ) );
		evTarget.appSeg( segOutData );
	    }
	    break;

#if 0
	case EQL_GETSLAVECFG:
	    {
		MmSeg segOutSlaveConfig;
		const MmSeg * psegInIfreq = evSciArg.getSegMatch(
		    addrIn, sizeof(struct ifreq) );
		if ( psegInIfreq != 0 && psegInIfreq->isBound( ) )
		{
		    const struct ifreq & ifreq =
			* (const struct ifreq *)
			( psegInIfreq->address( )
			+ ( addrIn - psegInIfreq->getAddrFirst( ) ) );
		    MmRetCheck( segOutSlaveConfig.fetchProc( procFetch,
			MmArea::tyAreaData, tySegSlaveConfig,
			MmAddr( ifreq.ifr_data ), 1 ) );
		}
		evTarget.appSeg( segOutSlaveConfig );
	    }
	    break;

	case EQL_GETMASTRCFG:
	    {
		MmSeg segOutMasterConfig;
		const MmSeg * psegInIfreq = evSciArg.getSegMatch(
		    addrIn, sizeof(struct ifreq) );
		if ( psegInIfreq != 0 && psegInIfreq->isBound( ) )
		{
		    const struct ifreq & ifreq =
			* (const struct ifreq *)
			( psegInIfreq->address( )
			+ ( addrIn - psegInIfreq->getAddrFirst( ) ) );
		    MmRetCheck( segOutMasterConfig.fetchProc( procFetch,
			MmArea::tyAreaData, tySegMasterConfig,
			MmAddr( ifreq.ifr_data ), 1 ) );
		}
		evTarget.appSeg( segOutMasterConfig );
	    }
	    break;
#endif

	case FDRAWCMD:
	    {
		MmSeg segOutData;
		const MmSeg * psegInFloppyRawCmd = evSciArg.getSegMatch(
		    addrIn, sizeof(struct floppy_raw_cmd) );
		if ( psegInFloppyRawCmd != 0 && psegInFloppyRawCmd->isBound( ) )
		{
		    const struct floppy_raw_cmd & floppy_raw_cmd =
			* (const struct floppy_raw_cmd *)
			( psegInFloppyRawCmd->address( )
			+ ( addrIn - psegInFloppyRawCmd->getAddrFirst( ) ) );
		    if ( ( floppy_raw_cmd.flags & FD_RAW_READ ) != 0
		    &&   floppy_raw_cmd.length >= 0 )
		    {
			MmRetCheck( segOutData.fetchProc( procFetch,
			    MmArea::tyAreaData, tySegAny,
			    MmAddr( floppy_raw_cmd.data ),
			    floppy_raw_cmd.length ) );
		    }
		}
		evTarget.appSeg( segOutData );
	    }
	    break;

	case GIO_FONTX:
	    {
		MmSeg segOutData;
		const MmSeg * psegInConsolefontdesc = evSciArg.getSegMatch(
		    addrIn, sizeof(struct consolefontdesc) );
		if ( psegInConsolefontdesc != 0
		&&   psegInConsolefontdesc->isBound( ) )
		{
		    const struct consolefontdesc & consolefontdesc =
			* (const struct consolefontdesc *)
			( psegInConsolefontdesc->address( )
			+ ( addrIn - psegInConsolefontdesc->getAddrFirst( ) )
			);
		    const int nChar = consolefontdesc.charcount;
		    if ( MmAddr( consolefontdesc.chardata ) != 0
		    &&   nChar >= 0 )
		    {
			MmRetCheck( segOutData.fetchProc( procFetch,
			    MmArea::tyAreaData, tySegAny,
			    MmAddr( consolefontdesc.chardata ),
			    nChar * sizeof(MmByte) ) );
		    }
		}
		evTarget.appSeg( segOutData );
	    }
	    break;

	case GIO_UNIMAP:
	    {
		MmSeg segOutListUnipair;
		const MmSeg * psegInUnimapdesc = evSciArg.getSegMatch(
		    addrIn, sizeof(struct unimapdesc) );
		if ( psegInUnimapdesc != 0 && psegInUnimapdesc->isBound( ) )
		{
		    const struct unimapdesc & unimapdesc =
			* (const struct unimapdesc *)
			( psegInUnimapdesc->address( )
			+ ( addrIn - psegInUnimapdesc->getAddrFirst( ) ) );
		    const int nEntry = unimapdesc.entry_ct;
		    if ( nEntry >= 0 )
		    {
			MmRetCheck( segOutListUnipair.fetchProc( procFetch,
			    MmArea::tyAreaData, tySegListUnipair,
			    MmAddr( unimapdesc.entries ), nEntry ) );
		    }
		}
		evTarget.appSeg( segOutListUnipair );
	    }
	    break;

	case KDADDIO:
	case KDDELIO:
	case KDDISABIO:
	case KDENABIO:
	case KDMAPDISP:
	case KDUNMAPDISP:
	    // These enable and disable direct port access.
	    evTarget.setUnknown( true );
	    break;

	case SCSI_IOCTL_PROBE_HOST:
	    {
		MmSeg segOutData;
		const MmSeg * psegInLen = evSciArg.getSegMatch(
		    addrIn, sizeof(MmWord) );
		if ( psegInLen != 0 && psegInLen->isBound( ) )
		{
		    const MmWord & sData =
			* (const MmWord *)
			( psegInLen->address( )
			+ ( addrIn - psegInLen->getAddrFirst( ) ) );
		    if ( int( sData ) >= 0 )
		    {
			MmRetCheck( segOutData.fetchProc( procFetch,
			    MmArea::tyAreaData, tySegAny, addrIn, sData ) );
		    }
		}
		evTarget.appSeg( segOutData );
	    }
	    break;

	case SIOCGIFCONF:
	    {
		MmSeg segOutListIfreq;
		const MmSeg * psegInIfconf = evSciArg.getSegMatch(
		    addrIn, sizeof(struct ifconf) );
		if ( psegInIfconf != 0 && psegInIfconf->isBound( ) )
		{
		    const struct ifconf & ifconf =
			* (const struct ifconf *)
			( psegInIfconf->address( )
			+ ( addrIn - psegInIfconf->getAddrFirst( ) ) );
		    if ( ifconf.ifc_len >= 0 )
		    {
			MmRetCheck( segOutListIfreq.fetchProc( procFetch,
			    MmArea::tyAreaData, tySegListIfreq,
			    MmAddr( ifconf.ifc_buf ), ifconf.ifc_len ) );
		    }
		}
		evTarget.appSeg( segOutListIfreq );
	    }
	    break;
	}
    }

    // That's all, folks.
    return mmRetOk;
}



// Fetch segout's (combiner).
MmRet FetchOutMmap
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    // Fetch the argument segment.
    //   This is needed because it gets smashed on replay.
    MmWord wAddrArg;
    if ( !procFetch.fetchReg( 0, wAddrArg ) )
	WhAbort( "FetchOutMmap: failed fetch." );
    MmSeg segListArg;
    MmRetCheck( segListArg.fetchProc( procFetch, MmArea::tyAreaData,
	tySegListMmWord, MmAddr( wAddrArg ), 6 ) );
    evTarget.appSeg( segListArg );

    // Fetch the mapped segment.
    if ( !evScoScr.isScrError( ) )
    {
	// Check storeability.
	switch ( evSciArg.getArg( 3 ) & MAP_TYPE )
	{
	default:
	    evTarget.setUnknown( true );
	    break;

	case MAP_PRIVATE:
	    break;

	case MAP_SHARED:
	    if ( ( evSciArg.getArg( 2 ) & PROT_WRITE ) != 0 )
		evTarget.setUnknown( true );
	    break;
	}

	// Fetch segment.
	MmSeg segOutMap;
	const MmAddr addrMin = MmAddr( evScoScr.getScrWord( 0 ) );
	const MmAddr addrMax = addrMin
	    + ( ( evSciArg.getArg( 1 ) + (4096-1) ) & ~(4096-1) );
	if ( addrMax > addrMin )
	{
	    MmRetCheck( segOutMap.fetchProc( procFetch, MmArea::tyAreaMmap,
		tySegAny, addrMin, addrMax - addrMin ) );
	    segOutMap.setAreaNew( true );
	}
	evTarget.appSeg( segOutMap );
    }
    return mmRetOk;
}



// Fetch segout's (combiner).
MmRet FetchOutModifyLdt
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    switch ( evSciArg.getArg( 0 ) )
    {
    default:
	evTarget.setUnknown( true );
	break;

    case 0:
	{
	    MmSeg segOutModifyLdtLdtS;
	    if ( !evScoScr.isScrError( ) && int( evScoScr.getScrWord( 0 ) ) >= 0 )
	    {
		MmRetCheck( segOutModifyLdtLdtS.fetchProc( procFetch,
		    MmArea::tyAreaData, tySegModifyLdtLdtS,
		    MmAddr( evSciArg.getArg( 1 ) ),
		    int( evScoScr.getScrWord( 0 ) ) ) );
	    }
	    evTarget.appSeg( segOutModifyLdtLdtS );
	}
	break;

    case 1:
	break;
    }

    return mmRetOk;
}



// Fetch segout's (combiner).
MmRet FetchOutMprotect
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    if ( !evScoScr.isScrError( ) )
    {
	// This is conservative.
	//   I have no use cases for this call!
	if ( ( evSciArg.getArg( 2 ) & PROT_WRITE ) != 0 )
	    evTarget.setUnknown( true );
    }
    return mmRetOk;
}



// Fetch segout's (combiner).
MmRet FetchOutMsgctl
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    switch ( evSciArg.getArg( 0 ) )
    {
    default:
	evTarget.setUnknown( true );
	break;

    case IPC_RMID:
    case IPC_SET:
	break;

    case IPC_INFO:
    case MSG_INFO:
	{
	    MmSeg segOutMsginfo;
	    MmRetCheck( segOutMsginfo.fetchProc( procFetch, MmArea::tyAreaData,
		tySegMsginfo, MmAddr( evSciArg.getArg( 4 ) ), 1 ) );
	    evTarget.appSeg( segOutMsginfo );
	}
	break;

    case IPC_STAT:
    case MSG_STAT:
	{
	    MmSeg segOutMsqidDs;
	    MmRetCheck( segOutMsqidDs.fetchProc( procFetch, MmArea::tyAreaData,
		tySegMsqidDs, MmAddr( evSciArg.getArg( 4 ) ), 1 ) );
	    evTarget.appSeg( segOutMsqidDs );
	}
	break;
    }

    return mmRetOk;
}



// Fetch segout's (combiner).
MmRet FetchOutMsgrcv0
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    MmSeg segOutMsgbuf;
    const MmAddr addrIpcKludge = MmAddr( evSciArg.getArg( 4 ) );
    const MmSeg * psegInIpcKludge = evSciArg.getSegMatch(
	addrIpcKludge, sizeof(struct ipc_kludge) );
    if ( psegInIpcKludge != 0 && psegInIpcKludge->isBound( ) )
    {
	const struct ipc_kludge & ipc_kludge =
	    * (const struct ipc_kludge *)
	    ( psegInIpcKludge->address( )
	    + ( addrIpcKludge - psegInIpcKludge->getAddrFirst( ) ) );
	if ( !evScoScr.isScrError( ) && int( evScoScr.getScrWord( 0 ) ) >= 0 )
	{
	    // Carefully fetch right size.
	    struct msgbuf msgbufForSize;
	    MmRetCheck( segOutMsgbuf.fetchProc( procFetch, MmArea::tyAreaData,
		tySegMsgbuf,
		MmAddr( ipc_kludge.msgp ),
		MmAddr( &msgbufForSize.mtext[int( evScoScr.getScrWord( 0 ) )] )
		- MmAddr( &msgbufForSize ) ) );
	}
    }
    evTarget.appSeg( segOutMsgbuf );
    return mmRetOk;
}



MmRet FetchOutMsgrcv1
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    MmSeg segOutMsgbuf;
    if ( !evScoScr.isScrError( ) && int( evScoScr.getScrWord( 0 ) ) >= 0 )
    {
	// Carefully fetch right size.
	struct msgbuf msgbufForSize;
	MmRetCheck( segOutMsgbuf.fetchProc( procFetch, MmArea::tyAreaData,
	    tySegMsgbuf,
	    MmAddr( evSciArg.getArg( 4 ) ),
	    MmAddr( &msgbufForSize.mtext[int( evScoScr.getScrWord( 0 ) )] )
	    - MmAddr( &msgbufForSize ) ) );
    }
    evTarget.appSeg( segOutMsgbuf );
    return mmRetOk;
}



// Fetch segout's (combiner).
MmRet FetchOutMunmap
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    if ( !evScoScr.isScrError( ) )
    {
	const MmAddr addrMin = MmAddr( evSciArg.getArg( 0 ) );
	const MmAddr addrMax = addrMin
	    + ( ( evSciArg.getArg( 1 ) + (4096-1) ) & ~(4096-1) );
	if ( addrMax > addrMin )
	{
	    MmSeg segOutBlank;
	    segOutBlank.setAreaFree( MmArea( MmArea::tyAreaBlank,
		addrMin, addrMax ) );
	    evTarget.appSeg( segOutBlank );
	}
    }
    return mmRetOk;
}



// Fetch segout's (combiner).
MmRet FetchOutNewselect
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    return FetchOutSelect( procFetch, mapFetch, evSciArg, evScoScr, evTarget );
}



// Fetch segout's (combiner).
MmRet FetchOutPtrace
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    switch ( evSciArg.getArg( 0 ) )
    {
    default:
	evTarget.setUnknown( true );
	break;

    case PTRACE_ATTACH:
    case PTRACE_CONT:
    case PTRACE_DETACH:
    case PTRACE_KILL:
    case PTRACE_POKEDATA:
    case PTRACE_POKETEXT:
    case PTRACE_POKEUSR:
    case PTRACE_SINGLESTEP:
    case PTRACE_SYSCALL:
    case PTRACE_TRACEME:
	break;

    case PTRACE_PEEKDATA:
    case PTRACE_PEEKTEXT:
    case PTRACE_PEEKUSR:
	// Linux 1.2.0: third argument is ret ptr.
	{
	    MmSeg segOutMmWord;
	    if ( !evScoScr.isScrError( ) )
	    {
		MmRetCheck( segOutMmWord.fetchProc( procFetch,
		    MmArea::tyAreaData, tySegMmWord,
		    MmAddr( evSciArg.getArg( 3 ) ), 1 ) );
	    }
	    evTarget.appSeg( segOutMmWord );
	}
	break;
    }

    return mmRetOk;
}



// Fetch segout's (combiner).
//   On error, fetch whole segment, in case kernel wrote partial.
MmRet FetchOutRead
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    MmSeg segOutData;
    const int sData = evScoScr.isScrError( )
			? int( evSciArg.getArg( 2 ) )
			: int( evScoScr.getScrWord( 0 ) );
    if ( sData >= 0 )
    {
	MmRetCheck( segOutData.fetchProc( procFetch, MmArea::tyAreaData,
	    tySegStrCount, MmAddr( evSciArg.getArg( 1 ) ), sData ) );
    }
    evTarget.appSeg( segOutData );
    return mmRetOk;
}



// Fetch segout's (combiner).
MmRet FetchOutReaddir
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    if ( !evScoScr.isScrError( ) && evScoScr.getScrWord( 0 ) > 0 )
    {
	// For size.
	struct dirent direntForSize;

	// Fetch first part for length.
	MmSeg segOutDirentHead;
	MmRetCheck( segOutDirentHead.fetchProc( procFetch, MmArea::tyAreaData,
	    tySegDirent, MmAddr( evSciArg.getArg( 1 ) ),
	      (const char *) ( &direntForSize.d_name[0] )
	    - (const char *) ( &direntForSize ) ) );
	const struct dirent & direntHead =
	    * (const struct dirent *) segOutDirentHead.address( );

	// Fetch for real.
	MmSeg segOutDirent;
	MmRetCheck( segOutDirent.fetchProc( procFetch, MmArea::tyAreaData,
	    tySegDirent, MmAddr( evSciArg.getArg( 1 ) ),
	      (const char *) ( &direntForSize.d_name[direntHead.d_reclen+1] )
	    - (const char *) ( &direntForSize ) ) );
	evTarget.appSeg( segOutDirent );
    }
    return mmRetOk;
}



// Fetch segout's (combiner).
//   On error, fetch whole segment, in case kernel wrote partial.
MmRet FetchOutRecv
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    MmSeg segOutData;
    const int sData = evScoScr.isScrError( )
			? int( evSciArg.getArg( 2 ) )
			: int( evScoScr.getScrWord( 0 ) );
    if ( sData >= 0 )
    {
	MmRetCheck( segOutData.fetchProc( procFetch, MmArea::tyAreaData,
	    tySegStrCount, MmAddr( evSciArg.getArg( 1 ) ), sData ) );
    }
    evTarget.appSeg( segOutData );
    return mmRetOk;
}



// Fetch segout's (combiner).
//   On error, fetch whole segment, in case kernel wrote partial.
MmRet FetchOutRecvfrom
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    MmSeg segOutData;
    const int sData = evScoScr.isScrError( )
			? int( evSciArg.getArg( 2 ) )
			: int( evScoScr.getScrWord( 0 ) );
    if ( sData >= 0 )
    {
	MmRetCheck( segOutData.fetchProc( procFetch, MmArea::tyAreaData,
	    tySegStrCount, MmAddr( evSciArg.getArg( 1 ) ), sData ) );
    }
    evTarget.appSeg( segOutData );
    return mmRetOk;
}



// Fetch segout's (combiner).
MmRet FetchOutRecvmsg
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    // Grab the msghdr.
    const MmAddr addrMsghdr = MmAddr( evSciArg.getArg( 1 ) );
    const MmSeg * psegInMsghdr = evSciArg.getSegMatch(
	addrMsghdr, sizeof(struct msghdr) );

    // Fetch segments.
    if ( psegInMsghdr != 0 && psegInMsghdr->isBound( ) )
    {
	const struct msghdr msghdr =
	    * (const struct msghdr *)
	    ( psegInMsghdr->address( )
	    + ( addrMsghdr - psegInMsghdr->getAddrFirst( ) ) );

	// Fetch socket name.
	MmSeg segOutName;
	if ( MmAddr( msghdr.msg_name ) != 0 && msghdr.msg_namelen >= 0 )
	{
	    MmRetCheck( segOutName.fetchProc( procFetch,
		MmArea::tyAreaData, tySegListMmByte,
		MmAddr( msghdr.msg_name ), msghdr.msg_namelen ) );
	}
	evTarget.appSeg( segOutName );

	// Fetch iovec list.
	MmSeg segOutListIovec;
	if ( msghdr.msg_iovlen >= 0 )
	{
	    MmRetCheck( segOutListIovec.fetchProc( procFetch,
		MmArea::tyAreaData, tySegListIovec,
		MmAddr( msghdr.msg_iov ), msghdr.msg_iovlen ) );
	}
	evTarget.appSeg( segOutListIovec );

	// Fetch accrights.
	MmSeg segOutAccrights;
	if ( MmAddr( msghdr.msg_accrights ) != 0
	&&   msghdr.msg_accrightslen >= 0 )
	{
	    MmRetCheck( segOutAccrights.fetchProc( procFetch,
		MmArea::tyAreaData, tySegAny,
		MmAddr( msghdr.msg_accrights ), msghdr.msg_accrightslen ) );
	}
	evTarget.appSeg( segOutAccrights );

	// Grab original iovec list.
	//   Beware aliasing.
	if ( msghdr.msg_iovlen >= 0 )
	{
	    const MmAddr addrListIovec = MmAddr( msghdr.msg_iov );
	    const MmSeg * psegInListIovec = evSciArg.getSegMatch(
		addrListIovec, msghdr.msg_iovlen * sizeof(struct iovec) );
	    if ( psegInListIovec != 0 && psegInListIovec->isBound( ) )
	    {
		const MmSeg segInListIovec = *psegInListIovec;
		const struct iovec * plIovec =
		    (const struct iovec *)
		    ( segInListIovec.address( )
		    + ( addrListIovec - segInListIovec.getAddrFirst( ) ) );

		// Fetch data segments.
		for ( int iIovec = 0; iIovec < msghdr.msg_iovlen; ++iIovec )
		{
		    MmSeg segOutData;
		    MmRetCheck( segOutData.fetchProc( procFetch,
			MmArea::tyAreaData, tySegAny,
			MmAddr( plIovec[iIovec].iov_base ),
			plIovec[iIovec].iov_len ) );
		    evTarget.appSeg( segOutData );
		}
	    }
	}
    }

    // That's all, folks.
    return mmRetOk;
}



// Fetch segout's (combiner).
MmRet FetchOutSelect
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    const int fd     = evSciArg.getArg( 0 );
    const int sFdset = fd > 0
			 ? ( (fd-1) / __NFDBITS + 1 ) * sizeof(MmWord)
			 : sizeof(fd_set);

    if ( MmAddr( evSciArg.getArg( 1 ) ) != 0 )
    {
	MmSeg segOutFdsetRead;
	MmRetCheck( segOutFdsetRead.fetchProc( procFetch, MmArea::tyAreaData,
	    tySegAny, MmAddr( evSciArg.getArg( 1 ) ), sFdset ) );
	evTarget.appSeg( segOutFdsetRead );
    }

    if ( MmAddr( evSciArg.getArg( 2 ) ) != 0 )
    {
	MmSeg segOutFdsetWrite;
	MmRetCheck( segOutFdsetWrite.fetchProc( procFetch, MmArea::tyAreaData,
	    tySegAny, MmAddr( evSciArg.getArg( 2 ) ), sFdset ) );
	evTarget.appSeg( segOutFdsetWrite );
    }

    if ( MmAddr( evSciArg.getArg( 3 ) ) != 0 )
    {
	MmSeg segOutFdsetExcept;
	MmRetCheck( segOutFdsetExcept.fetchProc( procFetch, MmArea::tyAreaData,
	    tySegAny, MmAddr( evSciArg.getArg( 3 ) ), sFdset ) );
	evTarget.appSeg( segOutFdsetExcept );
    }

    if ( MmAddr( evSciArg.getArg( 4 ) ) != 0 )
    {
	MmSeg segOutTimeval;
	MmRetCheck( segOutTimeval.fetchProc( procFetch, MmArea::tyAreaData,
	    tySegTimeval, MmAddr( evSciArg.getArg( 4 ) ), 1 ) );
	evTarget.appSeg( segOutTimeval );
    }

    return mmRetOk;
}



// Fetch segout's (combiner).
MmRet FetchOutSemctl
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    switch ( evSciArg.getArg( 3 ) )
    {
    default:
    	evTarget.setUnknown( true );
	break;

    case GETNCNT:
    case GETPID:
    case GETVAL:
    case GETZCNT:
    case IPC_RMID:
    case IPC_SET:
    case SETALL:
    case SETVAL:
	break;

    case GETALL:
	{
	    const MmAddr addrSemun = MmAddr( evSciArg.getArg( 4 ) );
	    const MmSeg * psegInSemun = evSciArg.getSegMatch(
		addrSemun, sizeof(union semun) );
	    if ( psegInSemun != 0 && psegInSemun->isBound( ) )
	    {
		const union semun & semun =
		    * (const union semun *)
		    ( psegInSemun->address( )
		    + ( addrSemun - psegInSemun->getAddrFirst( ) ) );

		MmSeg segOutListMmShort;
		if ( !evScoScr.isScrError( ) )
		{
		    MmRetCheck( segOutListMmShort.fetchProc( procFetch,
			MmArea::tyAreaData, tySegListMmShort,
			MmAddr( semun.array ), SEMMSL ) );
		}
		evTarget.appSeg( segOutListMmShort );
	    }
	}
	break;

    case IPC_INFO:
    case SEM_INFO:
	{
	    const MmAddr addrSemun = MmAddr( evSciArg.getArg( 4 ) );
	    const MmSeg * psegInSemun = evSciArg.getSegMatch(
		addrSemun, sizeof(union semun) );
	    if ( psegInSemun != 0 && psegInSemun->isBound( ) )
	    {
		const union semun & semun =
		    * (const union semun *)
		    ( psegInSemun->address( )
		    + ( addrSemun - psegInSemun->getAddrFirst( ) ) );

		MmSeg segOutSeminfo;
		if ( !evScoScr.isScrError( ) )
		{
		    MmRetCheck( segOutSeminfo.fetchProc( procFetch,
			MmArea::tyAreaData, tySegSeminfo,
			MmAddr( semun.__buf ), 1 ) );
		}
		evTarget.appSeg( segOutSeminfo );
	    }
	}
	break;

    case IPC_STAT:
    case SEM_STAT:
	{
	    const MmAddr addrSemun = MmAddr( evSciArg.getArg( 4 ) );
	    const MmSeg * psegInSemun = evSciArg.getSegMatch(
		addrSemun, sizeof(union semun) );
	    if ( psegInSemun != 0 && psegInSemun->isBound( ) )
	    {
		const union semun & semun =
		    * (const union semun *)
		    ( psegInSemun->address( )
		    + ( addrSemun - psegInSemun->getAddrFirst( ) ) );

		MmSeg segOutSemidDs;
		if ( !evScoScr.isScrError( ) )
		{
		    MmRetCheck( segOutSemidDs.fetchProc( procFetch,
			MmArea::tyAreaData, tySegSemidDs,
			MmAddr( semun.buf ), 1 ) );
		}
		evTarget.appSeg( segOutSemidDs );
	    }
	}
	break;
    }

    return mmRetOk;
}



// Fetch segout's (combiner).
MmRet FetchOutShmctl
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    switch ( evSciArg.getArg( 2 ) )
    {
    default:
	evTarget.setUnknown( true );
	break;

    case IPC_RMID:
    case IPC_SET:
    case SHM_LOCK:
    case SHM_UNLOCK:
	break;

    case IPC_INFO:
	{
	    MmSeg segOutShminfo;
	    MmRetCheck( segOutShminfo.fetchProc( procFetch, MmArea::tyAreaData,
		tySegShminfo, MmAddr( evSciArg.getArg( 4 ) ), 1 ) );
	    evTarget.appSeg( segOutShminfo );
	}
	break;

    case IPC_STAT:
    case SHM_STAT:
	{
	    MmSeg segOutShmidDs;
	    MmRetCheck( segOutShmidDs.fetchProc( procFetch, MmArea::tyAreaData,
		tySegShmidDs, MmAddr( evSciArg.getArg( 4 ) ), 1 ) );
	    evTarget.appSeg( segOutShmidDs );
	}
	break;

    case SHM_INFO:
	{
	    MmSeg segOutShmInfo;
	    MmRetCheck( segOutShmInfo.fetchProc( procFetch, MmArea::tyAreaData,
		tySegShmInfo, MmAddr( evSciArg.getArg( 4 ) ), 1 ) );
	    evTarget.appSeg( segOutShmInfo );
	}
	break;
    }

    return mmRetOk;
}



// Fetch segout's (combiner).
MmRet FetchOutSysfs
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    switch ( evSciArg.getArg( 0 ) )
    {
    default:
	evTarget.setUnknown( true );

    case 1:
    case 3:
	break;

    case 2:
	{
	    MmSeg segOutName;
	    if ( !evScoScr.isScrError( ) )
	    {
		MmRetCheck( segOutName.fetchProc( procFetch,
		    MmArea::tyAreaData, tySegStrNul,
		    MmAddr( evSciArg.getArg( 2 ) ), 1 ) );
	    }
	    evTarget.appSeg( segOutName );
	}
	break;
    }

    return mmRetOk;
}



// Fetch segout's (combiner).
//   On error, fetch whole segment, in case kernel wrote partial.
MmRet FetchOutSyslog
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    switch ( evSciArg.getArg( 0 ) )
    {
    default:
	evTarget.setUnknown( true );
	break;

    case 0:
    case 1:
    case 5:
    case 6:
    case 7:
    case 8:
	break;

    case 2:
    case 3:
    case 4:
	{
	    MmSeg segOutData;
	    const int sData = evScoScr.isScrError( )
				? int( evSciArg.getArg( 2 ) )
				: int( evScoScr.getScrWord( 0 ) );
	    if ( sData >= 0 )
	    {
		MmRetCheck( segOutData.fetchProc( procFetch,
		    MmArea::tyAreaData, tySegStrCount,
		    MmAddr( evSciArg.getArg( 1 ) ), sData ) );
	    }
	    evTarget.appSeg( segOutData );
	}
	break;
    }

    return mmRetOk;
}



// Fetch segout's (combiner).
MmRet FetchOutUselib
    ( const PrProc & procFetch, const MmMap & mapFetch,
      const EvSci  & evSciArg,  const EvSco & evScoScr,
      EvBase & evTarget )
{
    // Translate input flat to new segments.
    if ( !evScoScr.isScrError( ) )
    {
	if ( evSciArg.getFlat( ).count( ) == 0 )
	{
	    evTarget.setUnknown( true );
	}
	else
	{
	    WhList <MmSeg> lsegExe;
	    MmRetCheck( ExeLibToSeg( evSciArg.getFlat( )[0], lsegExe ) );
	    for ( int isegExe = 0; isegExe < lsegExe.count( ); ++isegExe )
		evTarget.appSeg( lsegExe[isegExe] );
	}
    }

#if 0
    // Fetch the name (replay smashes it).
    if ( evSciArg.getSeg( ).count( ) > 0 )
    {
	const MmSeg & segInName = evSciArg.getSeg( )[0];
	MmSeg segOutName;
	MmRetCheck( segOutName.fetchProc( procFetch, MmArea::tyAreaData,
	    tySegStrCount, segInName.getAddrFirst( ), segInName.count( ) ) );
	evTarget.appSeg( segOutName );
    }
#endif

    // That's all, folks.
    return mmRetOk;
}
