// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: TraceArg.cc
//   Argument holder.
//   This is a concrete class.
//
// File Created:	05 Feb 1995		Michael Chastain
// Last Edited:		31 May 1995		Michael Chastain

#include <stdio.h>
#include <string.h>

#include <WhAbort.h>
#include <TraceArg.h>



// Constructor.
TraceArg::TraceArg( int argc, const char * const * argv,
    const char * const * envp )
    : fError_		( false		)
    , fHelp_		( false		)
    , fTime_		( false		)
    , strFileOut_	( "x1.trace"	)
    , argv_		( argv		)
    , envp_		( envp		)
    , iargTarget_	( 0		)
{
    // Validate arguments.
    if ( argc < 1 || argv == 0 || envp == 0 )
	WhAbort( "TraceArg::TraceArg: arguments bad." );

    // Collect flags.
    int iargFlag;
    for ( iargFlag = 1; argv[iargFlag] != 0; ++iargFlag )
    {
	// Grab the flag arg.
	const char * pstrFlag = argv[iargFlag];

	// Recognize flags.
	if      ( ::strcmp( pstrFlag, "--" ) == 0 ) { ++iargFlag; break;      }
	else if ( ::strcmp( pstrFlag, "-h" ) == 0 ) { fHelp_    = true;       }
	else if ( ::strcmp( pstrFlag, "-t" ) == 0 ) { fTime_    = true;       }
	else if ( ::strcmp( pstrFlag, "-o" ) == 0 )
	{
	    if ( argv[++iargFlag] == 0 )
	    {
		fError_ = true;
		return;
	    }
	    strFileOut_ = WhString( argv[iargFlag] );
	}
	else if ( pstrFlag[0] == '-' )
	{
	    fError_ = true;
	    return;
	}
	else
	{
	    break;
	}
    }

    // Record target arguments.
    iargTarget_ = iargFlag;

    // Require at least one more argument.
    if ( !fHelp_ && argv[iargFlag] == 0 )
	fError_ = true;
}



// Show usage.
void TraceArg::showUsage( const char * pstrVersion ) const
{
    const char * pstrName =
	(argv_ != 0 && argv_[0] != 0) ? argv_[0] : "<noname>";

    ::printf(
	"%s version %s (" __DATE__ ").\n"
	"Usage: %s [flags ...] program [argument ...]\n"
	"         -h           show this usage message\n"
	"         -t           time stamp each event\n"
	"         -o file      output to file (default 'x1.trace')\n"
	, pstrName, pstrVersion, pstrName );
}
