// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: TraceArg.h
//   Argument holder.
//   This is a concrete class.
//
// File Created:	05 Feb 1995		Michael Chastain
// Last Edited:		04 Jun 1995		Michael Chastain

#if !defined(TRACE_ARG_H)
#define TRACE_ARG_H

#include <WhString.h>



class	TraceArg
{
    // Constructor.
    public:
				TraceArg	( int,
						  const char * const *,
						  const char * const *
						  		   );

    // Usage interface.
    public:
	void			showUsage	( const char *	   ) const;

    // Accessors.
    public:
	bool			isError		(		   ) const;
	bool			hasHelp		(		   ) const;
	bool			hasTime		(		   ) const;
	const WhString &	getFileOut	(		   ) const;
	const char *		getTargetName	(		   ) const;
	const char * const *	getTargetArgv	(		   ) const;
	const char * const *	getTargetEnvp	(		   ) const;

    // Instance data.
    private:
	bool			fError_;	// Args have error.
	bool			fHelp_;		// '-h'.
	bool			fTime_;		// '-t'.
	WhString		strFileOut_;	// '-o file'.
	const char * const *	argv_;		// Original 'argv'.
	const char * const *	envp_;		// Original 'envp'.
	int			iargTarget_;	// First arg of target.
};



// Inline methods.

inline bool TraceArg::isError( ) const
{
    return fError_;
}

inline bool TraceArg::hasHelp( ) const
{
    return fHelp_;
}

inline bool TraceArg::hasTime( ) const
{
    return fTime_;
}

inline const WhString & TraceArg::getFileOut( ) const
{
    return strFileOut_;
}

inline const char * TraceArg::getTargetName( ) const
{
    if ( argv_ == 0 || argv_[iargTarget_] == 0 )
	return 0;
    return argv_[iargTarget_];
}

inline const char * const * TraceArg::getTargetArgv( ) const
{
    if ( argv_ == 0 )
	return 0;
    else
	return argv_ + iargTarget_;
}

inline const char * const * TraceArg::getTargetEnvp( ) const
{
    return envp_;
}



#endif
