// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: TySegEnumLix.h
//   Enumeration of all types of segments.
//
// Constraints:
//   These values are saved into files.
//   Their range must be dense (for fast validity checking).
//
// File Created:	10 Apr 1995		Michael Chastain
// Last Edited:		16 Sep 1995		Michael Chastain

#if !defined(TY_SEG_ENUM_LIX_H)
#define TY_SEG_ENUM_LIX_H

#include <MmTag.h>



enum	TySegEnumLix
{
	tySeg1MmByte		= int(mmTagEnumLix) + 1,
	tySeg1Selection,
	tySeg4MmWord8,
	tySegAny,
	tySegArea,
	tySegArpreq,
	tySegAsyncStruct,
	tySegAudioBufInfo,
	tySegAx25ParmsStruct,
	tySegBrk,
	tySegCdromMsf,
	tySegCdromMultisession,
	tySegCdromReadAudio,
	tySegCdromSubchnl,
	tySegCdromTi,
	tySegCdromTocentry,
	tySegCdromTochdr,
	tySegCdromVolctrl,
	tySegConsolefontdesc,
	tySegCoprBuffer,
	tySegCoprDebugBuf,
	tySegCoprMsg,
	tySegCycladesMonitor,
	tySegDirent,
	tySegFlock,
	tySegFloppyDriveParams,
	tySegFloppyDriveStruct,
	tySegFloppyFdcState,
	tySegFloppyMaxErrors,
	tySegFloppyRawCmd,
	tySegFloppyStruct,
	tySegFloppyWriteErrors,
	tySegFormatDescr,
	tySegHdDriveid,
	tySegHdGeometry,
	tySegIfconf,
	tySegIfreq,
	tySegIoctlCommand,
	tySegIpcKludge,
	tySegIpxConfigData,
	tySegItimerval,
	tySegKbdiacrs,
	tySegKbentry,
	tySegKbkeycode,
	tySegKbsentry,
	tySegListCdromFrame,
	tySegListDirent,
	tySegListGidT,
	tySegListIfreq,
	tySegListIovec,
	tySegListKernelSym,
	tySegListMmAddr,
	tySegListMmByte,
	tySegListMmShort,
	tySegListMmWord,
	tySegListSembuf,
	tySegListUnipair,
	tySegLpStats,
	tySegMasterConfig,
	tySegMidiInfo,
	tySegMmAddr,
	tySegMmByte,
	tySegMmByte8,
	tySegMmByte16,
	tySegMmByte48,
	tySegMmByte8192,
	tySegMmByteTabsz,
	tySegMmLoff,
	tySegMmShortTabsz,
	tySegMmWord,
	tySegMmWord2,
	tySegMmWord8,
	tySegModRoutines,
	tySegModifyLdtLdtS,
	tySegMpuCommandRec,
	tySegMsgbuf,
	tySegMsghdr,
	tySegMsginfo,
	tySegMsqidDs,
	tySegMtconfiginfo,
	tySegMtget,
	tySegMtop,
	tySegMtpos,
	tySegNewStat,
	tySegNewUtsname,
	tySegNil,
	tySegNrParmsStruct,
	tySegOldStat,
	tySegOldUtsname,
	tySegOldoldUtsname,
	tySegPatmgrInfo,
	tySegPidT,
	tySegPppDdinfo,
	tySegPppStats,
	tySegRlimit,
	tySegRtentry,
	tySegRusage,
	tySegSbiInstrument,
	tySegSccModem,
	tySegSccStat,
	tySegSemidDs,
	tySegSeminfo,
	tySegSemun,
	tySegSeqEventRec,
	tySegSerialMultiportStruct,
	tySegSerialStruct,
	tySegShmInfo,
	tySegShmidDs,
	tySegShminfo,
	tySegSigaction,
	tySegSigcontextStruct,
	tySegSigsetT,
	tySegSiocSgReq,
	tySegSiocVifReq,
	tySegSlaveConfig,
	tySegSlavingRequest,
	tySegSockaddrAx25,
	tySegStatfs,
	tySegStrCount,
	tySegStrNul,
	tySegStrNulArg,
	tySegStrNulEnv,
	tySegSymbolTable,
	tySegSynthInfo,
	tySegSysinfo,
	tySegTermio,
	tySegTermios,
	tySegTimeT,
	tySegTimeval,
	tySegTimex,
	tySegTimezone,
	tySegTms,
	tySegTtyStruct,
	tySegUidT,
	tySegUmsdosIoctl,
	tySegUnimapdesc,
	tySegUnimapinit,
	tySegUstat,
	tySegUtimbuf,
	tySegVm86Struct,
	tySegVtConsize,
	tySegVtMode,
	tySegVtSizes,
	tySegVtStat,
	tySegWinsize
};



// Manifest constants.
static const TySegEnumLix tySegMin	= tySeg1MmByte;
static const TySegEnumLix tySegMac	= tySegWinsize;



#endif
