// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: WhFile.h
//   File class.
//   This is an external resource handler class.
//
// File Created:	01 Mar 1995		Michael Chastain
// Last Edited:		30 May 1995		Michael Chastain

#if !defined(WH_FILE_H)
#define WH_FILE_H

#include <unistd.h>

#include <MmRet.h>
#include <WhString.h>



class	WhFile
{
    // File open type.
    public:
	enum	TyOpen
	{
	    tyOpenRead,		// Read a file.
	    tyOpenWriteData,	// Write a data file.
	    tyOpenWriteExe	// Write an exe file.
	};

    // Constructor and destructor.
    public:
    				WhFile		(		   );
    				~WhFile		(		   );

    // Forbidden copiers.
    private:
    				WhFile		( const WhFile &   );
	const WhFile &		operator =	( const WhFile &   );

    // Accessors.
    public:
	const WhString &	getName		(		   ) const;
	bool			isOpen		(		   ) const;

    // File interface.
    public:
	MmRet			openName	( const WhString &,
						  TyOpen	   );
	MmRet			unlinkName	( const WhString & );
	MmRet			closeFile	(		   );
	MmRet			readListChar	( WhList <char> &  );
	MmRet			writeListChar	( const
						  WhList <char> &  );

    // Instance data.
    private:
	WhString		strName_;	// File name.
	bool			fOpen_;		// File is open.
	bool			fOutput_;	// File is output.
	int			errnoLast_;	// Last errno returned.
	int			fdFile_;	// Unix file descriptor.
	off_t			icFile_;	// Current seek position.
	off_t			ncFile_;	// Size of file.
};



// Inline methods.

inline const WhString & WhFile::getName( ) const
{
    return strName_;
}

inline bool WhFile::isOpen( ) const
{
    return fOpen_;
}



#endif
