// Copyright 1994, 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: WhList.h
//   List template.
//   This is a template.
//
// File Created:	23 Jan 1994		Michael Chastain
// Last Reviewed:	24 Apr 1995		Michael Chastain
// Last Edited:		05 May 1995		Michael Chastain

#if !defined(WH_LIST_H)
#define WH_LIST_H



template <class T> class WhList
{
    // Constructors, copiers, and destructor.
    public:
				WhList		(			     );
				WhList		( const WhList <T> & lOld    );
	const WhList <T> &	operator =	( const WhList <T> & lOld    );
				~WhList		(			     );

    // Accessors.
    public:
	const T &		operator []	( int iData	       ) const;
	const T *		address		(		       ) const;
	int			count		(		       ) const;
	bool			isInRange	( int iData	       ) const;
	bool			isInRange	( const T * pData      ) const;

    // Mutators.
    public:
	void			append		( const T & dataNew	     );
	void			append		( const T *, int	     );
	void			append		( const WhList <T> &	     );
	void			clear		( int nDataMaxNew = 0	     );
	void			removeLast	(			     );
	void			removeOne	( int iData		     );

    // Helpers.
    private:
	void			expand		( int nDataNew		     );
	void			rangeError	( int iData	       ) const;

    // Instance data.
    private:
	int			nData_;
	int			nDataMax_;
	T *			pData_;
};



// Inline methods.

template <class T> inline const T & WhList<T>::operator [] ( int iData ) const
{
    if ( iData < 0 || iData >= nData_ )
	rangeError( iData );
    return pData_[iData];
}

template <class T> inline const T * WhList<T>::address( ) const
{
    return pData_;
}

template <class T> inline int WhList<T>::count( ) const
{
    return nData_;
}

template <class T> inline bool WhList<T>::isInRange( int iData ) const
{
    return iData >= 0 && iData < nData_;
}

template <class T> inline bool WhList<T>::isInRange( const T * pData ) const
{
    return pData != 0 && pData >= pData_ && pData < pData_ + nData_;
}

template <class T> inline void WhList<T>::removeLast( )
{
    if ( nData_ > 0 )
	--nData_;
}



#endif
