// Copyright 1994, 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: WhString.h
//   String class.
//   Strings may contain nulls and are *not* null-terminated.
//   This is a concrete class.
//
// File Created:	18 Jan 1994		Michael Chastain
// Last Reviewed:	12 Sep 1994		Michael Chastain
// Last Edited:		02 Jul 1995		Michael Chastain

#if !defined(WH_STRING_H)
#define WH_STRING_H

#include <WhList.h>



class	WhString
{
    // Constructors.
    public:
				WhString	(		   );
				WhString	( const char *	   );
				WhString	( const char *,int );

    // Accessors.
    public:
	char			operator []	( int		   ) const;
	const char *		address		(		   ) const;
	bool			checkCcs	(		   ) const;
	int			count		(		   ) const;
	bool			matchWithCase	( const WhString & ) const;

    // Mutators.
    public:
	void			clear		(		   );
	void			replaceChr	( char, char	   );

    // Appenders, raw.
    public:
	void			appChrRaw	( char		   );
	void			appStrRaw	( const char *	   );
	void			appStrRaw	( const WhString & );

    // Appenders, formatted.
    public:
	void			appChrFmt	( char 		   );
	void			appIntFmt	( unsigned int,
						  unsigned int = 10,
						  unsigned int = 1 );
	void			appPtrFmt	( const void *	   );
	void			appStrFmt	( const char *	   );
	void			appStrFmt	( const char *,int );
	void			appStrFmt	( const WhString & );

    // Helpers.
    private:
	void			appChrFmtPriv	( char cValue	   );

    // Instance data.
    private:
	WhList <char>		lcData_;
};



// Inline methods.

inline char WhString::operator [] ( int iChar ) const
{
    return lcData_[iChar];
}

inline int WhString::count( ) const
{
    return lcData_.count( );
}

inline void WhString::clear( )
{
    lcData_.clear( );
}

inline void WhString::appChrRaw( char cAppend )
{
    lcData_.append( cAppend );
}



#endif
