// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: CxStore.cc
//   Context for store.
//   This is a reference class.
//
// File Created:	01 Nov 1995		Michael Chastain
// Last Edited:		19 Nov 1995		Michael Chastain

#include <linux/unistd.h>
#include <string.h>
#include <unistd.h>

#include <CxStore.hh>
#include <ErMem.hh>
#include <ErPtr.hh>
#include <EvType.hh>
#include <MmInsn.hh>
#include <MmSeg.hh>
#include <PrProc.hh>
#include <MmType.hh>
#include <TySegLix.hh>



// Constructor.
CxStore::CxStore( int istTrack, int istRun, PrProc * & pproc,
    const PrSd & stashData, PrSl * & pstashLink, EvLog * & plog )
    : istTrack_		( istTrack	)
    , istRun_		( istRun	)
    , fTraceMe_		( false		)
    , fTraceSc_		( false		)
    , fStepWant_	( false		)
    , nStepWait_	( 0		)
    , addrCont_		( 0		)
    , lwArgSci_		(		)
    , lsegSci_		(		)
    , pproc_		( pproc		)
    , bpt_		(		)
    , stashData_	( stashData	)
    , pstashLink_	( pstashLink	)
    , plog_		( plog		)
{
    if ( pproc == 0 )
	ErPtr( );
    pproc = 0;

    if ( pstashLink == 0 )
	ErPtr( );
    pstashLink = 0;

    if ( plog == 0 )
	ErPtr( );
    plog = 0;
}



// Destructor.
CxStore::~CxStore( )
{
    if ( plog_ != 0 )
	delete plog_;
    plog_ = 0;

    if ( pstashLink_ != 0 )
	delete pstashLink_;
    pstashLink_ = 0;

    if ( pproc_ != 0 )
	delete pproc_;
    pproc_ = 0;
}



// Set sci values.
void CxStore::setSci( const WhList <MmWord> & lwArgSci,
    const WhLap <MmSeg> & lsegSci )
{
    lwArgSci_ = lwArgSci;

    lsegSci_.reset( lsegSci.count( ) );
    for ( int isegSci = 0; isegSci < lsegSci.count( ); ++isegSci )
    {
	MmSeg * psegSciCopy = new MmSeg( lsegSci[isegSci] );
	if ( psegSciCopy == 0 )
	    ErMem( );
	lsegSci_.appendAp( psegSciCopy );
    }
}



// Return whether to step.
//   This code is way MD!
bool CxStore::nextIsStep( bool fReplay )
{
    // Continue if step not requested or step deferred.
    if ( !fStepWant_ || nStepWait_ != 0 )
	return false;

    // Step if not a replay process.
    if ( !fReplay )
    {
	fStepWant_ = false;
	return true;
    }

    // Stepping through an execve?
    if ( getProc( ).getTyEvent( ) == tyEvExec )
    {
	nStepWait_ = 1;
	return false;
    }

    // Hard ugly case: replay process wants to step through sys call trap.
    //   Must continue twice to get replay effect.
    MmSeg segInsn;
    const int nInsn = int( insnSysTrap[0] );
    segInsn.fetchProc( getProc( ), tyMmText, tySegListInsn,
	MmAddr( getProc( ).fetchRegPc( ) ), nInsn );
    if ( segInsn.hasArea( ) && segInsn.hasData( ) )
    {
	if ( ::memcmp( segInsn.address( ), &insnSysTrap[1],
	    nInsn * sizeof(MmInsn) ) == 0 )
	{
	    // Linux 1.3.42: Traps only on known entries.
	    const MmWord wSysEntry = getProc( ).fetchReg( 6 );
	    if ( int( wSysEntry ) >= 0
	    &&   wSysEntry <= __NR_writev
	    &&   wSysEntry != __NR_afs_syscall )
	    {
		nStepWait_ = 2;
		return false;
	    }
	}
    }

    // Let it step.
    fStepWant_ = false;
    return true;
}
