// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: ErAbort.cc.
//   Abort due to internal error.
//
// File Created:	26 Mar 1995		Michael Chastain
// Last Edited:		06 Nov 1995		Michael Chastain

#include <unistd.h>

#include <ErAbort.hh>



// Use low-level calls and no more dynamic memory.
void ErAbort( const char * pcMessage )
{
    if ( pcMessage == 0 )
	pcMessage = "ErAbort: zero pointer.";

    ::write( 2, "*** Abort: ", 11 );
    for ( int icMessage = 0; pcMessage[icMessage] != '\0'; ++icMessage )
	::write( 2, pcMessage + icMessage, 1 );
    ::write( 2, "\n", 1 );
    ::abort( );
}
