// Copyright 1994, 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: EvExec.cc
//   An event, type 'execution in'.
//   Linux 1.3.30: kernel leaves regs from previous process; must fetch/store!
//
// File Created:	19 Sep 1994		Michael Chastain
// Last Reviewed:	15 Oct 1995		Michael Chastain
// Last Edited:		12 Nov 1995		Michael Chastain

#include <CxFetch.hh>
#include <CxStore.hh>
#include <ErAbort.hh>
#include <ErFatal.hh>
#include <EvExec.hh>
#include <EvType.hh>
#include <PrProc.hh>
#include <WhFlatIn.hh>
#include <WhFlatOut.hh>



// Constructor.
EvExec::EvExec( )
    : fInit_	( false		)
    , wSp_	( 0		)
    , wFl_	( 0		)
    , lwInit_	(		)
{
    ;
}



// Destructor.
EvExec::~EvExec( )
{
    ;
}



// RTTI.
const EvExec * EvExec::ptrEvExec ( ) const
{
    return this;
}



// Flat input (combiner).
void EvExec::fromFlatEv( WhFlatIn & flatIn )
{
    flatIn.getBool	( fInit_	);
    flatIn.getWord	( wSp_		);
    flatIn.getWord	( wFl_		);
    flatIn.getListWord	( lwInit_	);
}



// Flat output (combiner).
void EvExec::toFlatEv( WhFlatOut & flatOut ) const
{
    flatOut.putBool	( fInit_	);
    flatOut.putWord	( wSp_		);
    flatOut.putWord	( wFl_		);
    flatOut.putListWord	( lwInit_	);
}



// String output (combiner).
void EvExec::fmtStrEv( WhString & strRet ) const
{
    strRet.appStrRaw( "<EvExec>\n" );
}



// Fetch from process.
void EvExec::fetch( CxFetch & cxFetch )
{
    if ( fInit_ )
	ErAbort( "EvExec::fetch: is bound." );

#if defined(MEC_TARGET_LIX)
    cxFetch.getProc( ).fetchListReg ( 0, 7, lwInit_ );
#endif

#if defined(MEC_TARGET_SUN)
#endif

    wSp_   = cxFetch.getProc( ).fetchRegSp( );
    wFl_   = cxFetch.getProc( ).fetchRegFl( );
    fInit_ = true;
}



// Store to process.
void EvExec::storeAw( CxStore & cxStore ) const
{
    // Check synchronization.
    if ( cxStore.getProc( ).getTyEvent( ) != tyEvExec )
	ErFatal( "EvExec::storeAw: mismatched event." );

    // Check initialization.
    if ( !fInit_ )
	ErFatal( "EvExec::storeAw: not bound." );

    // Check sp.
    if ( wSp_ != cxStore.getProc( ).fetchRegSp( ) )
	ErFatal( "EvExec::storeAw: stack pointer mismatch." );

    // Store registers.
    for ( int iwInit = 0; iwInit < lwInit_.count( ); ++iwInit )
	cxStore.getProc( ).storeReg( iwInit, lwInit_[iwInit] );
    cxStore.getProc( ).storeRegFl ( wFl_ );
}



// Store to process.
void EvExec::storeBc( CxStore & ) const
{
    ;
}
