// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: EvExit.cc
//   An event, type 'exit'.
//
// File Created:	08 Nov 1995		Michael Chastain
// Last Edited:		12 Nov 1995		Michael Chastain

#include <CxFetch.hh>
#include <ErAbort.hh>
#include <EvExit.hh>
#include <PrProc.hh>
#include <WhFlatIn.hh>
#include <WhFlatOut.hh>
#include <WhString.hh>



// Constructor.
EvExit::EvExit( )
    : fStatus_	( false	)
    , iStatus_	( 0	)
{
    ;
}



// Destructor.
EvExit::~EvExit( )
{
    ;
}



// Flat input (combiner).
void EvExit::fromFlatEv( WhFlatIn & flatIn )
{
    flatIn.getBool	( fStatus_	);
    flatIn.getInt	( iStatus_	);
}



// Flat output (combiner).
void EvExit::toFlatEv( WhFlatOut & flatOut ) const
{
    flatOut.putBool	( fStatus_	);
    flatOut.putInt	( iStatus_	);
}



// String output (combiner).
void EvExit::fmtStrEv( WhString & strRet ) const
{
    strRet.appStrRaw( "<EvExit>"		);
    if ( fStatus_ )
    {
	strRet.appStrRaw( " 0x"			);
	strRet.appIntFmt( iStatus_, 16, 4	);
    }
    strRet.appChrRaw( '\n'			);
}



// Fetch from process.
void EvExit::fetch( CxFetch & cxFetch )
{
    if ( fStatus_ )
	ErAbort( "EvExit::fetch: is bound." );

    iStatus_ = cxFetch.getProc( ).getStatusWait( );
    fStatus_ = true;
}



// Store to process.
void EvExit::storeAw( CxStore & ) const
{
    ;
}



// Store to process.
void EvExit::storeBc( CxStore & ) const
{
    ;
}
