// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: EvFirst.cc
//   An event, type 'first event'.
//
// File Created:	31 May 1995		Michael Chastain
// Last Edited:		12 Nov 1995		Michael Chastain

#include <sys/utsname.h>
#include <netdb.h>
#include <unistd.h>

#include <ErAbort.hh>
#include <ErFatal.hh>
#include <EvFirst.hh>
#include <WhFlatIn.hh>
#include <WhFlatOut.hh>



// Constructor.
EvFirst::EvFirst( )
    : strFqdnTarget_	(   )
    , ipidTrace_	( 0 )
{
    ;
}



// Destructor.
EvFirst::~EvFirst( )
{
    ;
}



// Flat input (combiner).
void EvFirst::fromFlatEv( WhFlatIn & flatIn )
{
    flatIn.getString	( strFqdnTarget_	);
    flatIn.getInt	( ipidTrace_		);
}



// Flat output (combiner).
void EvFirst::toFlatEv( WhFlatOut & flatOut ) const
{
    flatOut.putString	( strFqdnTarget_	);
    flatOut.putInt	( ipidTrace_		);
}



// String output (combiner).
void EvFirst::fmtStrEv( WhString & strRet ) const
{
    strRet.appStrRaw( "<EvFirst> fqdn-target: \""	);
    strRet.appStrRaw( strFqdnTarget_			);
    strRet.appStrRaw( "\" pid-trace: "			);
    strRet.appIntFmt( ipidTrace_			);
    strRet.appChrRaw( '\n'				);
}



// Fetch from process.
//   Make this a unique identifier across all space and time:
//     FQDN (fully qualified domain name)
//     Process id
//   Individual events have time stamps.
void EvFirst::fetch( CxFetch & )
{
    if ( ipidTrace_ != 0 )
	ErAbort( "EvFirst::fetch: is bound." );

    // Fetch the fully qualifed domain name.
    struct utsname utsname;
    if ( ::uname( &utsname ) != 0 )
	ErFatal( "EvFirst::fetch: failed uname." );
    const struct hostent * phostent = ::gethostbyname( utsname.nodename );

    // Save it, with a default.
    strFqdnTarget_.clear( );
    if ( phostent != 0 && phostent->h_name != 0 )
	strFqdnTarget_.appStrRaw( phostent->h_name );
    else
	strFqdnTarget_.appStrRaw( utsname.nodename );

    // Get a process id.
    //   Target isn't created yet so use mine.
    ipidTrace_ = ::getpid( );
}



// Store to process.
void EvFirst::storeAw( CxStore & ) const
{
    ;
}



// Store to process.
void EvFirst::storeBc( CxStore & ) const
{
    ;
}
