// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: EvSci.hh
//   An event, type 'system call ingoing'.
//   This is a leaf class.
//
// File Created:	11 Apr 1995		Michael Chastain
// Last Edited:		12 Nov 1995		Michael Chastain

#if !defined(EV_SCI_HH)
#define EV_SCI_HH

#include <EvBase.hh>
#include <MmType.hh>
#include <WhList.hh>



class	EvSci			: public EvBase
{
    // Constructor and destructor.
    public:
				EvSci		(		   );
				~EvSci		(		   );

    // RTTI.
    public:
	const EvSci *		ptrEvSci	(		   ) const;

    // Flat interface (combiner).
    private:
	void			fromFlatEv	( WhFlatIn  &	   );
	void			toFlatEv	( WhFlatOut &	   ) const;

    // String interface (combiner).
    private:
	void			fmtStrEv	( WhString &	   ) const;

    // Process interface.
    public:
	void			fetch		( CxFetch &	   );
	void			storeAw		( CxStore &	   ) const;
	void			storeBc		( CxStore &	   ) const;

    // Accessors.
    public:
	MmWord			getArg		( int		   ) const;
	MmWord			getSysEntry	(		   ) const;
	MmWord			getSubEntry	(		   ) const;
	bool			hasArg		(		   ) const;

    // Helpers.
    private:
	bool			matchArg	( bool, const
						  WhList<MmWord>&  ) const;

    // Instance data.
    private:
	bool			fArgTried_;	// Tried to fetch args.
	bool			fArgFetched_;	// Have fetched args.
	bool			fBound_;	// Bound to value.
	MmWord			wSysEntry_;	// Sys entry #.
	MmWord			wSubEntry_;	// Sub entry #.
	WhList <MmWord>		lwArg_;		// Arguments.
};



#endif
