// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: EvSco.cc
//   An event, type 'system call outcoming'.
//   This is a leaf class.
//
// File Created:	13 Apr 1995		Michael Chastain
// Last Edited:		12 Nov 1995		Michael Chastain

#include <CxFetch.hh>
#include <CxStore.hh>
#include <ErAbort.hh>
#include <ErFatal.hh>
#include <EvSci.hh>
#include <EvSco.hh>
#include <EvType.hh>
#include <MmArea.hh>
#include <MmScr.hh>
#include <MmSeg.hh>
#include <MmType.hh>
#include <PrProc.hh>
#include <PrSl.hh>
#include <ScLine.hh>
#include <WhFlatIn.hh>
#include <WhFlatOut.hh>
#include <WhList.hh>



// Constructor.
EvSco::EvSco( )
    : fBound_		( false			)
    , fCompare_		( false 		)
    , lwCompare_	(			)
    , lwSmash_		(			)
    , scr_		( MmScr::tyScrUnbound	)
{
    ;
}



// Destructor.
EvSco::~EvSco( )
{
    ;
}



// RTTI.
const EvSco * EvSco::ptrEvSco( ) const
{
    return this;
}



// Flat input (combiner).
void EvSco::fromFlatEv( WhFlatIn & flatIn )
{
    flatIn.getBool	( fBound_	);
    flatIn.getBool	( fCompare_	);
    flatIn.getListWord	( lwCompare_	);
    flatIn.getListWord	( lwSmash_	);
    scr_.fromFlat	( flatIn	);
}



// Flat output (combiner).
void EvSco::toFlatEv( WhFlatOut & flatOut ) const
{
    flatOut.putBool	( fBound_	);
    flatOut.putBool	( fCompare_	);
    flatOut.putListWord	( lwCompare_	);
    flatOut.putListWord	( lwSmash_	);
    scr_.toFlat		( flatOut	);
}



// Format to string (combiner).
void EvSco::fmtStrEv( WhString & strRet ) const
{
    if ( !fBound_ )
	ErAbort( "EvSco::fmtStr: not bound." );
    strRet.appStrRaw( "  = " );
    scr_.fmtScr( strRet );
}



// Fetch from process.
void EvSco::fetch( CxFetch & cxFetch )
{
    // Check bound.
    if ( fBound_ )
	ErAbort( "EvSco::fetch: is bound." );

    // Get components.
    const EvSci  & evSciFetch = cxFetch.getEvSci ( );
    const PrProc & procFetch  = cxFetch.getProc  ( );

    // Fetch fetch fetch.
    ScLine scLineIn;
    scLineIn.initFromSce ( evSciFetch.getSysEntry( ), evSciFetch.getSubEntry( ) );
    scLineIn.fetchSco    ( procFetch, fCompare_, lwCompare_, lwSmash_, scr_ );
    scLineIn.fetchDs     ( cxFetch,   *this );
    scLineIn.fetchSeg    ( cxFetch,   *this );

    // That's all, folks.
    fBound_ = true;
}



// Store to process.
void EvSco::storeAw( CxStore & cxStore ) const
{
    // Check synchronization.
    if ( cxStore.getProc( ).getTyEvent( ) != tyEvSco )
	ErFatal( "EvSco::storeAw: mismatched event." );

    // Check value.
    if ( !fBound_ )
	ErAbort( "EvSco::storeAw: not bound." );

    // Compare against process.
    if ( fCompare_ )
    {
	// Compare registers.
	WhList <MmWord> lwCompare;
	cxStore.getProc( ).fetchAllReg( lwCompare );
	if ( lwCompare.count( ) != lwCompare_.count( ) )
	    ErFatal( "EvSco::storeAw: register miscount." );
	for ( int iwCompare = 0; iwCompare < lwCompare.count( ); ++iwCompare )
	{
	    if ( lwCompare[iwCompare] != lwCompare_[iwCompare] )
		ErFatal( "EvSco::storeAw: register mismatch." );
	}

	// Compare return.
	MmScr scrCompare( scr_.getTyScr( ) );
	scrCompare.fetchProc( cxStore.getProc( ) );
	if ( !scrCompare.match( scr_ ) )
	    ErFatal( "EvSco::storeAw: scr mismatch." );
    }

    // Reset stash.
    cxStore.getStashLink( ).resetStash( );

    // Store sys call return value.
    scr_.storeProc( cxStore.getProc( ) );

    // Store smashed registers.
    for ( int iSmash = 0; iSmash < lwSmash_.count( ); ++iSmash )
	cxStore.getProc( ).storeReg( iSmash, lwSmash_[iSmash] );

    // Store segments.
    for ( int isegOut = 0; isegOut < countSeg( ); ++isegOut )
    {
	const MmSeg & segOut = getSeg( isegOut );
	if ( segOut.hasArea( ) && segOut.hasData( ) )
	    segOut.storeProc( cxStore.getProc( ) );
    }
}



// Store to process.
void EvSco::storeBc( CxStore & ) const
{
    ;
}
