// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: EvSco.hh
//   An event, type 'system call outcoming'.
//   This is a leaf class.
//
// File Created:	13 Apr 1995		Michael Chastain
// Last Edited:		12 Nov 1995		Michael Chastain

#if !defined(EV_SCO_HH)
#define EV_SCO_HH

#include <EvBase.hh>
#include <MmScr.hh>
#include <MmType.hh>
#include <WhList.hh>



class	EvSco			: public EvBase
{
    // Constructor and destructor.
    public:
				EvSco		(		   );
				~EvSco		(		   );

    // RTTI.
    public:
	const EvSco *		ptrEvSco	(		   ) const;

    // Flat interface (combiner).
    private:
	void			fromFlatEv	( WhFlatIn  &	   );
	void			toFlatEv	( WhFlatOut &	   ) const;

    // String interface (combiner).
    private:
	void			fmtStrEv	( WhString &	   ) const;

    // Process interface.
    public:
	void			fetch		( CxFetch &	   );
	void			storeAw		( CxStore &	   ) const;
	void			storeBc		( CxStore &	   ) const;

    // Return value interface.
    public:
	bool			isScrError	(		   ) const;
	MmWord			getScrWord	( int		   ) const;

    // Instance data.
    private:
	bool			fBound_;	// Bound to value.
	bool			fCompare_;	// Compare on store.
	WhList <MmWord>		lwCompare_;	// Regs to compare.
	WhList <MmWord>		lwSmash_;	// Regs smashed on replay.
	MmScr			scr_;		// Sys call return.
};



// Inline methods.

inline bool EvSco::isScrError( ) const
{
    return scr_.isError( );
}

inline MmWord EvSco::getScrWord( int iwScr ) const
{
    return scr_.getWord( iwScr );
}



#endif
