// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: EvSignal.cc
//   An event, type 'signal'.
//
// File Created:	31 Oct 1995		Michael Chastain
// Last Edited:		18 Nov 1995		Michael Chastain

#include <sys/types.h>
#include <sys/wait.h>

#include <CxFetch.hh>
#include <CxStore.hh>
#include <ErAbort.hh>
#include <EvSignal.hh>
#include <WhFlatIn.hh>
#include <WhFlatOut.hh>



// Constructor.
EvSignal::EvSignal( )
    : fFetched_	( false	)
    , isig_	( 0	)
{
    ;
}



// Destructor.
EvSignal::~EvSignal( )
{
    ;
}



// Flat input (combiner).
void EvSignal::fromFlatEv( WhFlatIn & flatIn )
{
    flatIn.getBool	( fFetched_	);
    flatIn.getInt	( isig_		);
}



// Flat output (combiner).
void EvSignal::toFlatEv( WhFlatOut & flatOut ) const
{
    flatOut.putBool	( fFetched_	);
    flatOut.putInt	( isig_		);
}



// String output (combiner).
void EvSignal::fmtStrEv( WhString & strRet ) const
{
    strRet.appStrRaw( "SIGNAL "	);
    if ( fFetched_ )
	strRet.appIntFmt( isig_	);
    else
	strRet.appStrRaw( "***"	);
    strRet.appChrRaw( '\n'	);
}



// Fetch from process.
void EvSignal::fetch( CxFetch & cxFetch )
{
    if ( fFetched_ )
	ErAbort( "EvSignal::fetch: is bound." );
    setModelFail( "SIGNAL: not implemented" );
    int istatusWait = cxFetch.getProc( ).getStatusWait( );
    isig_     = WSTOPSIG(istatusWait);
    fFetched_ = true;
}



// Store to process.
void EvSignal::storeAw( CxStore & ) const
{
    ErAbort( "EvSignal::storeAw: not implemented." );
}



// Store to process.
void EvSignal::storeBc( CxStore & ) const
{
    ErAbort( "EvSignal::storeBc: not implemented." );
}
