// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: ListArg.cc
//   Argument holder.
//   This is a concrete class.
//
// File Created:	05 Jun 1995		Michael Chastain
// Last Edited:		06 Nov 1995		Michael Chastain

#include <stdio.h>
#include <string.h>

#include <ErPtr.hh>
#include <ListArg.hh>



// Constructor.
ListArg::ListArg( const char * argv [] )
    : fError_		( false	)
    , fHelp_		( false	)
    , strNameSelf_	(	)
    , strNameTrace_	(	)
{
    // Check arguments.
    if ( argv == 0 )
	ErPtr( );

    // Collect name.
    strNameSelf_.appStrRaw( argv[0] );

    // Collect flags.
    int iargFlag;
    for ( iargFlag = 1; argv[iargFlag] != 0; ++iargFlag )
    {
	// Grab the flag arg.
	const char * pcFlag = argv[iargFlag];

	// Recognize flags.
	if      ( ::strcmp( pcFlag, "--" ) == 0 ) { ++iargFlag; break; }
	else if ( ::strcmp( pcFlag, "-h" ) == 0 ) { fHelp_     = true; }
	else if ( pcFlag[0] == '-' )
	{
	    fError_ = true;
	    return;
	}
	else
	{
	    break;
	}
    }

    // Require exactly one more argument.
    if ( !fHelp_ )
    {
	if ( argv[iargFlag] == 0 || argv[iargFlag+1] != 0 )
	    fError_ = true;
	else
	    strNameTrace_.appStrRaw( argv[iargFlag] );
    }
}



// Show usage.
void ListArg::showUsage( const char * pcVersion ) const
{
    ::printf(
	"%.*s version %s (" __DATE__ ").\n"
	"Usage: %.*s [flags ...] trace-file\n"
	"         -h           show this usage message\n"
	"         trace-file   file of trace data\n"
	,
	getNameSelf( ).count( ), getNameSelf( ).address( ),
	pcVersion,
	getNameSelf( ).count( ), getNameSelf( ).address( ) );
}
