// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: ListMain.cc
//   Main program for mec-list.
//
// File Created:	06 Nov 1995		Michael Chastain
// Last Edited:		06 Nov 1995		Michael Chastain

// Program version.
static const char acVersion [] = "0.3";



// Unix library.
#include <stdio.h>

// My library classes.
#include <ErFatal.hh>
#include <ErMem.hh>
#include <ErPtr.hh>
#include <ErUser.hh>
#include <EvBase.hh>
#include <EvType.hh>
#include <WhFlatIn.hh>
#include <WhImage.hh>
#include <WhString.hh>

// My application classes.
#include <ListArg.hh>



// Local functions.
int	do_list			( const ListArg & );



// Entry point.
int main( int, const char * argv [] )
{
    // Collect arguments.
    ListArg argList( argv );

    // Handle argument errors.
    if ( argList.isError( ) )
    {
	argList.showUsage( acVersion );
	return 2;
    }

    // Handle '-h' (help).
    if ( argList.hasHelp( ) )
    {
	argList.showUsage( acVersion );
	return 0;
    }

    // List.
    return do_list( argList );
}



// List a trace file.
int do_list( const ListArg & argList )
{
    // Map trace file into image.
    WhImage * pimageTrace = new WhImage( argList.getNameTrace( ) );
    if ( pimageTrace == 0 )
	ErMem( );
    if ( pimageTrace->isError( ) )
    {
	ErUser( argList.getNameSelf( ), "trace file",
	    argList.getNameTrace( ), pimageTrace->getError( ) );
	delete pimageTrace;
	return 1;
    }

    // Transfer image to flat.
    WhFlatIn flatTrace( pimageTrace );

    // Check tag.
    {
	int  iTag;
	if ( flatTrace.countLeft( ) < int( sizeof(int) )
	|| ( flatTrace.getInt( iTag ), iTag != 0x0300FACE ) )
	{
	    ErUser( argList.getNameSelf( ), "input file",
		argList.getNameTrace( ), "not a trace file" );
	    return 1;
	}
    }

    // List events.
    while ( !flatTrace.isAtEnd( ) )
    {
	// Create event.
	int ityEvent;
	flatTrace.getInt( ityEvent );
	EvBase * pevIn = TyEventCreateBase( TyEvent( ityEvent ) );
	if ( pevIn == 0 )
	    ErPtr( );

	// Get event.
	pevIn->fromFlat( flatTrace );

	WhString strList;
	pevIn->fmtStr( strList );
	if ( int( ::fwrite( strList.address( ), sizeof(char),
	    strList.count( ), stdout ) ) != strList.count( ) )
	{
	    ErFatal( "do_list: failed fwrite." );
	}
	delete pevIn;
    }

    // Success.
    return 0;
}
