// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: MmDs.cc
//   Target data set (file).
//   This is a concrete class.
//
// File Created:	23 Oct 1995		Michael Chastain
// Last Edited:		11 Nov 1995		Michael Chastain

#include <ErPtr.hh>
#include <MmDs.hh>
#include <WhFlatIn.hh>
#include <WhFlatOut.hh>
#include <WhImage.hh>
#include <WhString.hh>



// Constructor.
MmDs::MmDs( )
    : segName_		(   )
    , pimageData_	( 0 )
    , lcData_		(   )
    , iseq_		( 0 )
{
    ;
}



// Constructor.
//   Takes an image by linear pointer.
MmDs::MmDs( const MmSeg & segName, WhImage * & pimageData, int iseq )
    : segName_		( segName	)
    , pimageData_	( pimageData	)
    , lcData_		(		)
    , iseq_		( iseq		)
{
    if ( pimageData == 0 )
	ErPtr( );
    pimageData = 0;
}



// Destructor.
MmDs::~MmDs( )
{
    finalize( );
}



// Finalizer.
void MmDs::finalize( )
{
    if ( pimageData_ != 0 )
	delete pimageData_;
    pimageData_ = 0;
}



// Flat input.
void MmDs::fromFlat( WhFlatIn & flatIn )
{
    if ( pimageData_ != 0 )
    {
	delete pimageData_;
	pimageData_ = 0;
    }
    segName_.fromFlat	( flatIn	);
    flatIn.getListChar	( lcData_	);
    flatIn.getInt	( iseq_		);
}



// Flat output.
void MmDs::toFlat( WhFlatOut & flatOut ) const
{
    segName_.toFlat	 ( flatOut		);
    flatOut.putArrayChar ( address( ), count( )	);
    flatOut.putInt	 ( iseq_		);
}



// Format to string.
void MmDs::fmtStr( WhString & strRet ) const
{
    strRet.appStrRaw( "    <file> "	);
    strRet.appIntFmt( iseq_		);
    strRet.appChrRaw( ' '		);
    strRet.appIntFmt( count( )		);
    strRet.appStrRaw( " \""		);
    const char * pcName = (const char *) segName_.address( );
    const int ncName = segName_.count( ) / sizeof(char);
    for ( int icName = 0; icName < ncName - 1; ++icName )
	strRet.appChrFmt( pcName[icName] );
    strRet.appStrRaw( "\"\n"		);
}



// Return data address.
const char * MmDs::address( ) const
{
    if ( pimageData_ != 0 )
	return pimageData_->address( );
    else
	return lcData_.address( );
}



// Append smashed name.
void MmDs::appNameSmash( WhString & strNameSmash ) const
{
    MmSeg segNameSmash( segName_ );
    segNameSmash.checkCcs( );
    segNameSmash.replaceByte( MmByte( '/' ), MmByte( '%' ) );
    strNameSmash.appStrRaw( (const char *) segNameSmash.address( ) );
}



// Return data count.
int MmDs::count( ) const
{
    if ( pimageData_ != 0 )
	return pimageData_->count( );
    else
	return lcData_.count( );
}
