// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: MmDs.hh
//   Target data set (file).
//   This is a concrete class.
//
// File Created:	23 Oct 1995		Michael Chastain
// Last Edited:		11 Nov 1995		Michael Chastain

#if !defined(MM_DS_H)
#define MM_DS_H

#include <MmSeg.hh>
#include <MmType.hh>
#include <WhList.hh>

class	WhFlatIn;
class	WhFlatOut;
class	WhImage;
class	WhString;



class	MmDs
{
    // Life cycle methods.
    public:
				MmDs		(		   );
				MmDs		( const MmSeg &,
						  WhImage * &, int );
				~MmDs		(		   );
	void			finalize	(		   );

    // Forbidden copiers.
    private:
    				MmDs		( const MmDs &	   );
	void			operator =	( const MmDs &	   );

    // Flat interface.
    public:
	void			fromFlat	( WhFlatIn  &	   );
	void			toFlat		( WhFlatOut &	   ) const;

    // Formatter.
    public:
	void			fmtStr		( WhString &	   ) const;

    // Accessors.
    public:
	const char *		address		(		   ) const;
	void			appNameSmash	( WhString &	   ) const;
	int			count		(		   ) const;
	int			getSeq		(		   ) const;

    // Instance data.
    private:
    	MmSeg			segName_;	// Target file name.
    	WhImage *		pimageData_;	// Target data (if image).
    	WhList <char>		lcData_;	// Target data (no image).
    	int			iseq_;		// Sequence number.
};



// Inline methods.

inline int MmDs::getSeq( ) const
{
    return iseq_;
}



#endif
