// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: MsLine.hh
//   Memory segment line.
//   This is a struct.
//   This is a concrete class.
//
// File Created:	29 Jul 1995		Michael Chastain
// Last Edited:		01 Nov 1995		Michael Chastain

#if !defined(MS_LINE_HH)
#define MS_LINE_HH

class	CxFetch;
class	EvBase;



class	MsLine
{
    // Address types.
    public:
	enum	TyAddr
	{
	    tyAddrArg,				// Address in arg #N.
	    tyAddrArgNz				// Address in arg #N, non zero.
	};

    // Count types.
    public:
	enum	TyCount
	{
	    tyCountArg,				// Count in arg #N.
	    tyCountOne,				// Count is 1.
	    tyCountMem,				// Count in mem at reg #N.
	    tyCountRet,				// Count in return value.
	    tyCountSel				// Count in arg #N, 'select'.
	};

    // Process interface.
    public:
	static void		fetchArraySeg	( const MsLine [], int,
						  CxFetch&, EvBase & );

    // Helper.
    private:
	void			fetchSeg	( CxFetch&, EvBase & ) const;

    // Data table.
    private:
	bool			fIn_;		// Seg going into kernel.
	bool			fOutOk_;	// Seg coming out of kernel.
	bool			fOutError_;	// Seg coming out of kernel.
	int			itySeg_;	// Type of segment at memory.
	TyAddr			tyAddr_;	// Type of address.
	int			iAddr_;		// Index for address.
	TyCount			tyCount_;	// Type of count.
	int			iCount_;	// Index for count.
};



#endif
