// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: PrMap.hh
//   Target address map.
//   This is a concrete class.
//
// File Created:	24 Apr 1995		Michael Chastain
// Last Edited:		08 Nov 1995		Michael Chastain

#if !defined(PR_MAP_HH)
#define PR_MAP_HH

#include <MmArea.hh>
#include <MmSpace.hh>
#include <MmType.hh>
#include <WhLap.hh>



class	PrMap
{
    // Life cycle method.
    public:
				PrMap		(		   );

    // Forbidden copiers.
    private:
				PrMap		( const PrMap &	   );
	void			operator =	( const PrMap &	   );

    // Accessors.
    public:
	int			countArea	(		   ) const;
	MmAddr			getAddrBrk	(		   ) const;
	MmAddr			getAddrStackMax	(		   ) const;
	const MmArea &		getArea		( int		   ) const;

    // Mutator.
    public:
	void			mergeArea	( const MmArea &   );

    // Helper.
    private:
	static void		addArea		( WhLap <MmArea> &,
						  TyMmSpace,
						  MmAddr, MmAddr   );

    // Instance data.
    private:
	WhLap <MmArea>		larea_;		// List of areas.
};



// Inline methods.

inline int PrMap::countArea( ) const
{
    return larea_.count( );
}

inline const MmArea & PrMap::getArea( int iArea ) const
{
    return larea_[iArea];
}



#endif
