// Copyright 1995 Michael Chastain
// Licensed under the Gnu Public License, Version 2
//
// File: PrSd.hh
//   Data set stash for data.
//   This is an external resource handler class.
//
// File Created:	11 Nov 1995		Michael Chastain
// Last Edited:		12 Nov 1995		Michael Chastain

#if !defined(PR_SD_HH)
#define PR_SD_HH

#include <WhLap.hh>
#include <WhList.hh>
#include <WhString.hh>

class	MmDs;



class	PrSd
{
    // Life cycle methods.
    public:
				PrSd		( const WhString &,
						  const WhString & );
				~PrSd		(		   );
	void			finalize	(		   );

    // Forbidden copiers.
    private:
				PrSd		( const PrSd &	   );
	void			operator =	( const PrSd &	   );

    // Accessors.
    public:
	int			countExec	(		   ) const;
	const WhString &	getNameDir	(		   ) const;
	const WhString &	getNameExecData	( int		   ) const;
	const WhString &	getNameExecLink	( int		   ) const;

    // Stash interface.
    public:
	void			resetStash	(		   );
	void			stashFile	( const MmDs &	   );

    // Instance data.
    private:
	WhString		strNameDir_;	// Name of directory.
	WhString		strNameExec_;	// Name of exec'er.
	WhLap <WhString>	lstrNameFile_;	// Stashed files.
	WhList <int>		liExec_;	// Index to exec files.
};



// Inline methods.

inline int PrSd::countExec( ) const
{
    return liExec_.count( );
}

inline const WhString & PrSd::getNameDir( ) const
{
    return strNameDir_;
}

inline const WhString & PrSd::getNameExecData( int iExec ) const
{
    return lstrNameFile_[liExec_[iExec]];
}

inline const WhString & PrSd::getNameExecLink( int iExec ) const
{
    return lstrNameFile_[liExec_[iExec]+1];
}



#endif
